/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.AnsiPinBlock;
import net.e6tech.elements.security.hsm.atalla.Message;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.AtallaSimulator;
import net.e6tech.elements.security.hsm.atalla.simulator.ChangePIN;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;
import net.e6tech.elements.security.hsm.atalla.simulator.Echo;
import net.e6tech.elements.security.hsm.atalla.simulator.EncryptPIN;
import net.e6tech.elements.security.hsm.atalla.simulator.GenerateCVV;
import net.e6tech.elements.security.hsm.atalla.simulator.IBM3624PINOffset;
import net.e6tech.elements.security.hsm.atalla.simulator.ImportWorkingKey;
import net.e6tech.elements.security.hsm.atalla.simulator.TranslatePIN;
import net.e6tech.elements.security.hsm.atalla.simulator.TranslatePINBlock;
import net.e6tech.elements.security.hsm.atalla.simulator.VerifyPIN;

public abstract class Command
extends Message {
    private static Map<String, Class<? extends Command>> commands = new HashMap<String, Class<? extends Command>>();
    protected AtallaSimulator simulator;

    public Command() {
    }

    public Command(String response) {
        super(response);
    }

    public static Command createInstance(String message, AtallaSimulator simulator) {
        try {
            Message msg = new Message(message);
            Command request = commands.get(msg.getField(0)).newInstance();
            request.simulator = simulator;
            request.fields = msg.getFields();
            return request;
        }
        catch (Exception e) {
            Logger.suppress((Throwable)e);
            return null;
        }
    }

    void setFields(String[] fields) {
        this.fields = fields;
    }

    public Message process() {
        try {
            return new Message("<" + this.doProcess() + ">");
        }
        catch (CommandException e) {
            Logger.suppress((Throwable)e);
            return new Message("<00#" + e.error() + ">");
        }
    }

    protected abstract String doProcess() throws CommandException;

    public static <T> T run(int fieldNumber, Callable<T> call) throws CommandException {
        try {
            return call.call();
        }
        catch (Exception th) {
            throw new CommandException(fieldNumber, (Throwable)th);
        }
    }

    protected void setDecimalizationTable(IBM3624PINOffset ibm, int fieldNo) throws CommandException {
        String decTab = this.getField(fieldNo);
        if (decTab.indexOf(44) >= 0) {
            try {
                decTab = Hex.toString(this.simulator.decryptKey(new AKB(decTab)));
            }
            catch (GeneralSecurityException e) {
                throw new CommandException(fieldNo, (Throwable)e);
            }
        } else if (decTab.length() != 16) {
            throw new CommandException(fieldNo, (Throwable)new IllegalArgumentException());
        }
        try {
            ibm.setDecimalizationTable(decTab);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(fieldNo, (Throwable)e);
        }
    }

    protected AnsiPinBlock getPinBlock(int kpeField, int pinBlockField, int partialPanField) throws CommandException {
        AKB kpe = Command.run(kpeField, () -> new AKB(this.getField(kpeField)));
        byte[] pinBlock = Command.run(pinBlockField, () -> this.simulator.decrypt(kpe, this.getField(pinBlockField)));
        return new AnsiPinBlock(pinBlock, this.getField(partialPanField));
    }

    protected byte[] decryptKey(int keyField) throws CommandException {
        try {
            return this.simulator.decryptKey(new AKB(this.getField(keyField)));
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(keyField, (Throwable)e);
        }
    }

    protected byte[] decrypt(int keyField, int dataField) throws CommandException {
        AKB akb = Command.run(keyField, () -> new AKB(this.getField(keyField)));
        return Command.run(dataField, () -> this.simulator.decrypt(akb, this.getField(dataField)));
    }

    static {
        commands.put("00", Echo.class);
        commands.put("5D", GenerateCVV.class);
        commands.put("30", EncryptPIN.class);
        commands.put("37", ChangePIN.class);
        commands.put("32", VerifyPIN.class);
        commands.put("31", TranslatePIN.class);
        commands.put("11B", ImportWorkingKey.class);
        commands.put("335", TranslatePINBlock.class);
    }
}

