/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.security.PasswordEncrypted;
import net.e6tech.elements.security.RNG;
import net.e6tech.elements.security.SymmetricCipher;

public class PasswordEncryption {
    char[] password;
    public static final int SALT_LEN = 64;
    private final int KEYLEN_BITS = 256;
    private final int ITERATIONS = 1000;

    public PasswordEncryption(char[] password) {
        this.password = password;
    }

    public PasswordEncrypted encrypt(byte[] plain, String keyAlias, String keyVersion) throws GeneralSecurityException {
        byte[] iv = RNG.generateSeed(16);
        byte[] salt = RNG.generateSeed(64);
        return this.encrypt(salt, iv, plain, keyAlias, keyVersion);
    }

    public PasswordEncrypted encrypt(byte[] salt, byte[] iv, byte[] plain, String keyAlias, String keyVersion) throws GeneralSecurityException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        PBEKeySpec spec = new PBEKeySpec(this.password, salt, 1000, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7PADDING");
        cipher.init(1, (Key)secret, new IvParameterSpec(iv));
        byte[] encrypted = cipher.doFinal(plain);
        return new PasswordEncrypted(salt, iv, encrypted, keyAlias, keyVersion);
    }

    public byte[] decrypt(PasswordEncrypted encrypted) throws GeneralSecurityException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        PBEKeySpec spec = new PBEKeySpec(this.password, encrypted.getSalt(), 1000, 256);
        SecretKey tmp = factory.generateSecret(spec);
        byte[] hash = tmp.getEncoded();
        SecretKeySpec secret = new SecretKeySpec(hash, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7PADDING");
        cipher.init(2, (Key)secret, new IvParameterSpec(encrypted.getIv()));
        return cipher.doFinal(encrypted.getEncrypted());
    }

    static {
        SymmetricCipher.initialize();
    }
}

