/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla;

import net.e6tech.elements.security.hsm.atalla.BadMessageException;

public class Message {
    String[] fields;

    public Message() {
    }

    public Message(String message) {
        this.parse(message);
    }

    protected void parse(String message) {
        int beginIndex = message.indexOf("<");
        int endIndex = message.lastIndexOf(">");
        if (beginIndex < 0 || endIndex < 0) {
            throw new BadMessageException("Cannot find message delimiter");
        }
        if (beginIndex >= endIndex) {
            throw new BadMessageException("end delimiter is found before begin delimiter.");
        }
        message = message.substring(beginIndex + 1, endIndex);
        String[] tokens = message.split("#");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        this.fields = tokens;
    }

    public String getField(int index) {
        return this.fields[index];
    }

    public String[] getFields() {
        if (this.fields == null) {
            return null;
        }
        String[] flds = new String[this.fields.length];
        System.arraycopy(this.fields, 0, flds, 0, this.fields.length);
        return flds;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        if (this.fields != null) {
            for (String f : this.fields) {
                builder.append(f);
                builder.append("#");
            }
        }
        builder.append(">");
        return builder.toString();
    }
}

