/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;

public class VisaPVV {
    public static void main(String ... args) throws Exception {
        VisaPVV visa = new VisaPVV();
        String result = visa.generatePVV(Hex.toBytes("0123456789ABCDEFFEDCBA9876543210"), "56789987654", 1, "1234");
        System.out.println(result);
        byte[] kpe = Hex.toBytes("1111 1111 1111 1111");
        byte[] kpv = Hex.toBytes("3333 3333 3333 3333 4444 4444 4444 4444");
        String partialPan = "12345612345";
        int pvki = 1;
        System.out.println(visa.generatePVV(kpv, partialPan, pvki, "4321"));
    }

    public String generatePVV(byte[] pvvKeyBytes, String partialPan, int pvki, String pin) throws GeneralSecurityException {
        char c;
        int i;
        if (partialPan.length() != 11) {
            throw new GeneralSecurityException("invalid partial pan length, must be 11");
        }
        if (pin.length() != 4) {
            throw new GeneralSecurityException("invalid pin length, must be 4");
        }
        if (pvki > 9 || pvki < 0) {
            throw new GeneralSecurityException("invalid pvki, must be greater than or equal to 0 and less than 10.");
        }
        pvvKeyBytes = AKB.normalizeKey(pvvKeyBytes);
        SecretKeySpec pvv = new SecretKeySpec(pvvKeyBytes, "DESede");
        Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        cipher.init(1, pvv);
        byte[] clearTex = Hex.toBytes(partialPan + pvki + pin);
        byte[] encrypted = cipher.doFinal(clearTex);
        String result = Hex.toString(encrypted);
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < result.length(); ++i) {
            c = result.charAt(i);
            if (c < '0' || c > '9') continue;
            builder.append(c);
        }
        for (i = 0; i < result.length(); ++i) {
            c = result.charAt(i);
            if (c < 'A' || c > 'F') continue;
            builder.append("" + (c - 65));
        }
        return builder.toString().substring(0, 4);
    }
}

