/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm;

import net.e6tech.elements.common.util.StringUtil;
import net.e6tech.elements.security.Hex;

public class AnsiPinBlock {
    byte[] encoding;
    String pin;
    boolean sanityCheck = true;

    public AnsiPinBlock(String partialPan, String pin) {
        if (partialPan.length() != 12) {
            throw new IllegalArgumentException("invalid partial pan length, must be 12");
        }
        if (pin == null) {
            throw new IllegalArgumentException("null pin");
        }
        if (pin.length() < 4 || pin.length() > 12) {
            throw new IllegalArgumentException("invalid pin length.");
        }
        int pinLen = pin.length();
        String pinBlock = "0" + Hex.toNumeric(pinLen) + pin;
        pinBlock = StringUtil.padRight((String)pinBlock, (int)16, (char)'F');
        byte[] pinBytes = Hex.toBytes(pinBlock);
        byte[] panBytes = Hex.toBytes("0000" + partialPan);
        byte[] xor = new byte[8];
        for (int i = 0; i < 8; ++i) {
            xor[i] = (byte)(pinBytes[i] ^ panBytes[i]);
        }
        this.encoding = xor;
        this.pin = pin;
    }

    public AnsiPinBlock(byte[] encoding, String partialPan) {
        if (partialPan.length() != 12) {
            throw new IllegalArgumentException("invalid partial pan length, must be 12");
        }
        this.encoding = encoding;
        byte[] panBytes = Hex.toBytes("0000" + partialPan);
        byte[] pinBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            pinBytes[i] = (byte)(encoding[i] ^ panBytes[i]);
        }
        String pinStr = Hex.toString(pinBytes);
        int pinLen = Integer.parseInt(pinStr.substring(1, 2));
        this.pin = pinStr.substring(2, pinLen + 2);
        String leftOver = pinStr.substring(pinLen + 2);
        for (int i = 0; i < leftOver.length(); ++i) {
            char ch = leftOver.charAt(i);
            if (ch == 'F') continue;
            this.sanityCheck = false;
            break;
        }
    }

    public boolean isSanityCheck() {
        return this.sanityCheck;
    }

    public String getPIN() {
        return this.pin;
    }

    public byte[] getEncoding() {
        return this.encoding;
    }

    public static void main(String ... args) throws Exception {
        AnsiPinBlock ansi = new AnsiPinBlock("999789012345", "1234");
        System.out.println(Hex.toString(ansi.encoding));
        ansi = new AnsiPinBlock(ansi.encoding, "999789012345");
        System.out.println(ansi.pin);
    }
}

