/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import net.e6tech.elements.security.hsm.AnsiPinBlock;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;
import net.e6tech.elements.security.hsm.atalla.simulator.IBM3624PINOffset;
import net.e6tech.elements.security.hsm.atalla.simulator.VisaPVV;

public class VerifyPIN
extends Command {
    @Override
    protected String doProcess() throws CommandException {
        if (!this.getField(2).equals("1")) {
            return "000200";
        }
        if (this.getField(1).equals("2")) {
            if (this.getField(7).length() != 12) {
                return "001200";
            }
            return this.ibm3624();
        }
        if (this.getField(1).equals("3")) {
            return this.visaPVV();
        }
        return null;
    }

    protected String ibm3624() throws CommandException {
        IBM3624PINOffset ibm = new IBM3624PINOffset();
        this.setDecimalizationTable(ibm, 5);
        String offset = this.getField(6);
        String validation = this.getField(7);
        String pad = this.getField(8);
        AnsiPinBlock ansiPinBlock = this.getPinBlock(4, 3, 7);
        if (!ansiPinBlock.isSanityCheck()) {
            return "42#S#";
        }
        byte[] pvvKey = this.decryptKey(10);
        String computedOffset = null;
        try {
            computedOffset = ibm.generateOffset(pvvKey, validation, pad.charAt(0), ansiPinBlock.getPIN());
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(0, (Throwable)e);
        }
        if (computedOffset.equals(offset)) {
            return "42#Y#";
        }
        return "42#N#";
    }

    protected String visaPVV() throws CommandException {
        VisaPVV visa = new VisaPVV();
        byte[] pvvKey = this.decryptKey(5);
        String offset = this.getField(7);
        String pvkiStr = this.getField(8);
        String partialPan = this.getField(9);
        AnsiPinBlock ansiPinBlock = this.getPinBlock(4, 3, 10);
        if (!ansiPinBlock.isSanityCheck()) {
            return "42#S#";
        }
        int pvki = new Integer(pvkiStr);
        String computedOffset = null;
        try {
            computedOffset = visa.generatePVV(pvvKey, partialPan, pvki, ansiPinBlock.getPIN());
        }
        catch (GeneralSecurityException e) {
            return "001000";
        }
        if (computedOffset.equals(offset)) {
            return "42#Y#";
        }
        return "42#N#";
    }
}

