/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import java.security.GeneralSecurityException;
import java.util.Properties;
import net.e6tech.elements.security.SymmetricCipher;
import net.e6tech.elements.security.vault.ClearText;
import net.e6tech.elements.security.vault.Constants;
import net.e6tech.elements.security.vault.Secret;

public class KeyProtected {
    public Secret seal(String alias, ClearText clear, ClearText key) throws GeneralSecurityException {
        clear.setProperty("alias", alias);
        clear.setProtectedProperty("alias", alias);
        SymmetricCipher encryption = SymmetricCipher.getInstance("AES");
        encryption.setBase64(false);
        String iv = encryption.generateIV();
        String encrypted = encryption.encrypt(key.asSecretKey(), clear.getBytes(), iv);
        Secret secret = new Secret();
        secret.setProperties((Properties)clear.getProperties().clone());
        secret.setSecret(iv + "$" + encrypted + "$" + key.alias() + "$" + key.version());
        if (clear.getProperties() != null) {
            try {
                String str = Constants.mapper.writeValueAsString((Object)clear.getProtectedProperties());
                str = encryption.encrypt(key.asSecretKey(), str.getBytes("UTF-8"), iv);
                secret.setProtectedProperties(iv + "$" + str + "$" + key.alias() + "$" + key.version());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return secret;
    }

    public ClearText unseal(Secret secret, ClearText key) throws GeneralSecurityException {
        SymmetricCipher encryption = SymmetricCipher.getInstance("AES");
        encryption.setBase64(false);
        if (secret == null) {
            return null;
        }
        String encrypted = secret.getSecret();
        String[] components = encrypted.split("\\$");
        if (components.length != 4) {
            throw new IllegalStateException("The stored secret should have been formatted as 'iv$encypted$alias$version'");
        }
        if (!components[2].equalsIgnoreCase(key.alias())) {
            throw new GeneralSecurityException("Key alias mismatch");
        }
        if (!components[3].equalsIgnoreCase(key.version())) {
            throw new GeneralSecurityException("Key version mismatch");
        }
        byte[] plain = encryption.decrypt(key.asSecretKey(), components[1], components[0]);
        ClearText ct = new ClearText();
        ct.setBytes(plain);
        ct.setProperties((Properties)secret.getProperties().clone());
        if (secret.getProtectedProperties() != null) {
            components = secret.getProtectedProperties().split("\\$");
            if (components.length != 4) {
                throw new IllegalStateException("The protected properties should have been formatted as 'iv$encypted$alias$version");
            }
            if (!components[2].equalsIgnoreCase(key.alias())) {
                throw new GeneralSecurityException("Key alias mismatch");
            }
            if (!components[3].equalsIgnoreCase(key.version())) {
                throw new GeneralSecurityException("Key version mismatch");
            }
            byte[] props = encryption.decrypt(key.asSecretKey(), components[1], components[0]);
            try {
                Properties properties = (Properties)Constants.mapper.readValue(new String(props, "UTF-8"), Properties.class);
                ct.setProtectedProperties(properties);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ct;
    }
}

