/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import javax.crypto.Cipher;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.SymmetricCipher;

public class AsymmetricCipher {
    private String algorithm;
    private String transformation;
    private int keyLength = 2048;
    private boolean base64 = false;
    private KeyFactory keyFactory;

    public static AsymmetricCipher getInstance(String algorithm) {
        if ("RSA".equalsIgnoreCase(algorithm)) {
            return new AsymmetricCipher("RSA");
        }
        throw new IllegalArgumentException(algorithm + " is not supported");
    }

    protected AsymmetricCipher(String algorithm) {
        this.algorithm = algorithm;
        this.transformation = algorithm + "/None/OAEPWithSHA256AndMGF1Padding";
        try {
            this.keyFactory = KeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String encrypt(PublicKey key, byte[] plain) throws GeneralSecurityException {
        byte[] encrypted = this.encryptBytes(key, plain);
        if (this.base64) {
            return Base64.getEncoder().encodeToString(encrypted);
        }
        return Hex.toString(encrypted);
    }

    public byte[] encryptBytes(PublicKey publicKey, byte[] plain) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.transformation, "BC");
        cipher.init(1, publicKey);
        return cipher.doFinal(plain);
    }

    public byte[] decrypt(PrivateKey key, String encrypted) throws GeneralSecurityException {
        byte[] decodedBytes = this.base64 ? Base64.getDecoder().decode(encrypted) : Hex.toBytes(encrypted);
        return this.decryptBytes(key, decodedBytes);
    }

    public byte[] decryptBytes(PrivateKey privateKey, byte[] encrypted) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.transformation, "BC");
        cipher.init(2, privateKey);
        return cipher.doFinal(encrypted);
    }

    public KeyPair generateKeySpec() throws GeneralSecurityException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(this.keyLength);
        KeyPair kp = kpg.genKeyPair();
        return kp;
    }

    public KeyFactory getKeyFactory() {
        return this.keyFactory;
    }

    static {
        SymmetricCipher.initialize();
    }
}

