/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.util.Base64;
import javax.xml.bind.DatatypeConverter;

public class PasswordEncrypted {
    byte[] iv;
    byte[] salt;
    byte[] encrypted;
    String keyAlias;
    String keyVersion;

    public PasswordEncrypted() {
    }

    public PasswordEncrypted(byte[] salt, byte[] iv, byte[] encrypted, String keyAlias, String keyVersion) {
        this.salt = salt;
        this.iv = iv;
        this.encrypted = encrypted;
        this.keyAlias = keyAlias;
        this.keyVersion = keyVersion;
    }

    public PasswordEncrypted(String encoded) {
        String[] components = encoded.split("\\$");
        if (components.length <= 3) {
            throw new IllegalStateException("The stored password have the form 'salt$hash'");
        }
        boolean base64 = components[0].endsWith("==");
        if (base64) {
            this.salt = Base64.getDecoder().decode(components[0]);
            this.iv = Base64.getDecoder().decode(components[1]);
            this.encrypted = Base64.getDecoder().decode(components[2]);
        } else {
            this.salt = DatatypeConverter.parseHexBinary((String)components[0]);
            this.iv = DatatypeConverter.parseHexBinary((String)components[1]);
            this.encrypted = DatatypeConverter.parseHexBinary((String)components[2]);
        }
        if (components.length > 3) {
            this.keyAlias = components[3];
        }
        if (components.length > 4) {
            this.keyVersion = components[4];
        }
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getEncrypted() {
        return this.encrypted;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public String getBase64Iv() {
        return Base64.getEncoder().encodeToString(this.iv);
    }

    public String getHexIv() {
        return DatatypeConverter.printHexBinary((byte[])this.iv);
    }

    public String getBase64Salt() {
        return Base64.getEncoder().encodeToString(this.salt);
    }

    public String getHexSalt() {
        return DatatypeConverter.printHexBinary((byte[])this.salt);
    }

    public String getBase64Encrypted(boolean base64) {
        return Base64.getEncoder().encodeToString(this.encrypted);
    }

    public String getHexEncrypted() {
        return DatatypeConverter.printHexBinary((byte[])this.encrypted);
    }

    public String toBase64() {
        return Base64.getEncoder().encodeToString(this.salt) + "$" + Base64.getEncoder().encodeToString(this.iv) + "$" + Base64.getEncoder().encodeToString(this.encrypted) + "$" + this.keyAlias + "$" + this.keyVersion;
    }

    public String toHex() {
        return DatatypeConverter.printHexBinary((byte[])this.salt) + "$" + DatatypeConverter.printHexBinary((byte[])this.iv) + "$" + DatatypeConverter.printHexBinary((byte[])this.encrypted) + "$" + this.keyAlias + "$" + this.keyVersion;
    }
}

