/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Random;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.xml.bind.DatatypeConverter;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.RNG;

public class Password {
    private static final int iterations = 20000;
    private static final int saltLen = 64;
    private static final int desiredKeyLen = 512;

    public static char[] generateRandomPassword(int min, int max) {
        char ch;
        StringBuilder builder = new StringBuilder();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            builder.append(ch);
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            builder.append(ch);
        }
        for (ch = 'A'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            builder.append(ch);
        }
        builder.append("!@#$%^&*-_+=~|<>");
        String charSet = builder.toString();
        Random random = new Random();
        int len = min + random.nextInt(max - min);
        char[] password = new char[len];
        for (int i = 0; i < password.length; ++i) {
            int idx = random.nextInt(charSet.length());
            password[i] = charSet.charAt(idx);
        }
        return password;
    }

    public static String getSaltedHash(char[] password) throws GeneralSecurityException {
        return Password.getSaltedHash(password, false);
    }

    protected static String getSaltedHash(char[] password, boolean base64) throws GeneralSecurityException {
        byte[] salt = RNG.generateSeed(64);
        if (base64) {
            return Base64.getEncoder().encodeToString(salt) + "$" + Password.hash(password, salt, base64);
        }
        return Hex.toString(salt) + "$" + Password.hash(password, salt, base64);
    }

    public static boolean check(char[] password, String stored) throws GeneralSecurityException {
        if (stored == null) {
            return false;
        }
        String[] saltAndPass = stored.split("\\$");
        if (saltAndPass.length != 2) {
            throw new IllegalStateException("The stored password have the form 'salt$hash'");
        }
        boolean base64 = saltAndPass[0].endsWith("==");
        String hashOfInput = null;
        hashOfInput = base64 ? Password.hash(password, Base64.getDecoder().decode(saltAndPass[0]), base64) : Password.hash(password, DatatypeConverter.parseHexBinary((String)saltAndPass[0]), base64);
        return hashOfInput.equals(saltAndPass[1]);
    }

    private static String hash(char[] password, byte[] salt, boolean base64) throws GeneralSecurityException {
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("Empty passwords are not supported.");
        }
        SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        SecretKey key = f.generateSecret(new PBEKeySpec(password, salt, 20000, 512));
        if (base64) {
            return Base64.getEncoder().encodeToString(key.getEncoded());
        }
        return Hex.toString(key.getEncoded());
    }
}

