/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import net.e6tech.elements.security.hsm.AnsiPinBlock;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;
import net.e6tech.elements.security.hsm.atalla.simulator.IBM3624PINOffset;
import net.e6tech.elements.security.hsm.atalla.simulator.VisaPVV;

public class ChangePIN
extends Command {
    @Override
    protected String doProcess() throws CommandException {
        if (!this.getField(2).equals("1")) {
            return "000200";
        }
        if (this.getField(1).equals("2")) {
            if (this.getField(7).length() != 12) {
                return "001200";
            }
            return this.ibm3624();
        }
        if (this.getField(1).equals("3")) {
            return this.visaPVV();
        }
        return null;
    }

    protected String ibm3624() throws CommandException {
        String offset;
        AnsiPinBlock ansiPinBlock;
        String oldPinBlock = this.getField(3);
        String oldOffset = this.getField(6);
        String validation = this.getField(7);
        String pad = this.getField(8);
        IBM3624PINOffset ibm = new IBM3624PINOffset();
        this.setDecimalizationTable(ibm, 5);
        byte[] pvvKey = this.decryptKey(10);
        if (oldPinBlock.length() > 0) {
            ansiPinBlock = this.getPinBlock(4, 3, 7);
            offset = null;
            try {
                offset = ibm.generateOffset(pvvKey, validation, pad.charAt(0), ansiPinBlock.getPIN());
            }
            catch (GeneralSecurityException e) {
                throw new CommandException(0, (Throwable)e);
            }
            if (!oldOffset.equals(offset)) {
                return "47#N#";
            }
        }
        ansiPinBlock = this.getPinBlock(4, 11, 7);
        offset = null;
        try {
            offset = ibm.generateOffset(pvvKey, validation, pad.charAt(0), ansiPinBlock.getPIN());
        }
        catch (GeneralSecurityException e) {
            return "001000";
        }
        return "47#Y#" + offset;
    }

    protected String visaPVV() throws CommandException {
        String offset;
        AnsiPinBlock ansiPinBlock;
        String oldPinBlock = this.getField(3);
        String oldOffset = this.getField(7);
        String pvkiStr = this.getField(8);
        String partialPan = this.getField(9);
        int pvki = new Integer(pvkiStr);
        byte[] pvvKey = this.decryptKey(5);
        VisaPVV visa = new VisaPVV();
        if (oldPinBlock.length() > 0) {
            ansiPinBlock = this.getPinBlock(4, 3, 7);
            offset = null;
            try {
                offset = visa.generatePVV(pvvKey, partialPan, pvki, ansiPinBlock.getPIN());
            }
            catch (GeneralSecurityException e) {
                throw new CommandException(0, (Throwable)e);
            }
            if (!oldOffset.equals(offset)) {
                return "47#N#";
            }
        }
        ansiPinBlock = this.getPinBlock(4, 10, 11);
        offset = null;
        try {
            offset = visa.generatePVV(pvvKey, partialPan, pvki, ansiPinBlock.getPIN());
        }
        catch (GeneralSecurityException e) {
            return "001000";
        }
        return "47#Y#" + offset;
    }
}

