/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.AnsiPinBlock;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;

public class TranslatePIN
extends Command {
    @Override
    protected String doProcess() throws CommandException {
        if (!this.getField(1).equals("1")) {
            throw new CommandException(1, (Throwable)new IllegalArgumentException("only ANSI pin block is supported"));
        }
        AnsiPinBlock pinBlock = this.getPinBlock(2, 4, 5);
        try {
            AnsiPinBlock outgoing = new AnsiPinBlock(this.getField(5), pinBlock.getPIN());
            byte[] encrypted = this.simulator.encrypt(new AKB(this.getField(3)), outgoing.getEncoding());
            return "41#" + Hex.toString(encrypted) + "#Y#";
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(3, (Throwable)e);
        }
    }
}

