/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class RNG {
    private static String rngAlgorithm = "SHA1PRNG";

    public static SecureRandom getSecureRandom() {
        if (rngAlgorithm == null) {
            return new SecureRandom();
        }
        try {
            return SecureRandom.getInstance(rngAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return new SecureRandom();
        }
    }

    public static byte[] generateSeed(int len) {
        return RNG.getSecureRandom().generateSeed(len);
    }

    public static void nextBytes(byte[] bytes) {
        RNG.getSecureRandom().nextBytes(bytes);
    }

    static {
        try {
            rngAlgorithm = "NativePRNGNonBlocking";
            SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                rngAlgorithm = "SHA1PRNG";
                SecureRandom.getInstance(rngAlgorithm);
            }
            catch (NoSuchAlgorithmException e2) {
                rngAlgorithm = null;
            }
        }
    }
}

