/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Properties;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.security.Hex;

public class ClearText
implements Serializable {
    private static final long serialVersionUID = -6495396359046821847L;
    public static final String PUBLIC_KEY_MOD = "public-key-mod";
    public static final String PUBLIC_KEY_EXP = "public-key-exp";
    Properties properties = new Properties();
    Properties protectedProperties = new Properties();
    byte[] bytes;

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProtectedProperties() {
        return this.protectedProperties;
    }

    public void setProtectedProperties(Properties protectedProperties) {
        this.protectedProperties = protectedProperties;
    }

    public String toText() {
        if (this.bytes == null) {
            return null;
        }
        try {
            return new String(this.bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void resetText(String text) {
        try {
            this.setBytes(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] text) {
        this.bytes = text;
    }

    public String getProperty(String key) {
        if (this.getProperties() == null) {
            return null;
        }
        return this.getProperties().getProperty(key);
    }

    public void setProperty(String key, String value) {
        if (this.getProperties() == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
    }

    public String getProtectedProperty(String key) {
        if (this.getProtectedProperties() == null) {
            return null;
        }
        return this.getProtectedProperties().getProperty(key);
    }

    public void setProtectedProperty(String key, String value) {
        if (this.getProtectedProperties() == null) {
            this.protectedProperties = new Properties();
        }
        this.protectedProperties.setProperty(key, value);
    }

    public void protect() {
        if (this.getProtectedProperties() == null) {
            this.protectedProperties = new Properties();
        }
        for (String key : this.properties.stringPropertyNames()) {
            String value = this.properties.getProperty(key);
            if (value == null || this.protectedProperties.containsKey(key)) continue;
            this.protectedProperties.setProperty(key, this.properties.getProperty(key));
        }
    }

    public String toString() {
        return Hex.toString(this.bytes) + this.properties + this.protectedProperties;
    }

    public String alias() {
        return this.getProperty("alias");
    }

    public void alias(String alias) {
        this.setProperty("alias", alias);
        this.setProtectedProperty("alias", alias);
    }

    public String version() {
        return this.getProperty("version");
    }

    public void version(String version) {
        this.setProperty("version", version);
        this.setProtectedProperty("version", version);
    }

    public SecretKey asSecretKey() {
        SecretKeySpec secretKey = new SecretKeySpec(this.getBytes(), this.getProperty("algorithm"));
        return secretKey;
    }

    public KeyPair asKeyPair() throws GeneralSecurityException {
        try {
            String text = new String(this.getBytes(), "UTF-8");
            String[] components = text.split("\\$");
            if (components.length != 2) {
                throw new IllegalStateException("Invalid encryption format");
            }
            BigInteger mod = new BigInteger(components[0], 16);
            BigInteger exp = new BigInteger(components[1], 16);
            RSAPrivateKeySpec priv = new RSAPrivateKeySpec(mod, exp);
            mod = new BigInteger(this.getProtectedProperty(PUBLIC_KEY_MOD), 16);
            exp = new BigInteger(this.getProtectedProperty(PUBLIC_KEY_EXP), 16);
            RSAPublicKeySpec pub = new RSAPublicKeySpec(mod, exp);
            KeyFactory fact = KeyFactory.getInstance("RSA");
            PublicKey pubKey = fact.generatePublic(pub);
            PrivateKey privateKey = fact.generatePrivate(priv);
            return new KeyPair(pubKey, privateKey);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

