/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import net.e6tech.elements.common.util.Terminal;

public class Credential {
    private String user;
    private char[] password;

    public Credential() {
    }

    public Credential(String user, char[] password) {
        this.user = user;
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void run(String text) {
        Terminal term = new Terminal();
        while (this.user == null || this.password == null) {
            term.println(text);
            this.user = term.readLine("Username:");
            this.password = term.readPassword("Password:");
        }
    }

    public void run(String text, int port) {
        if (this.user != null && this.user.length() > 0 && this.password != null && this.password.length > 0) {
            return;
        }
        ServerSocket serverSocket = null;
        Terminal t = null;
        try {
            serverSocket = new ServerSocket(port);
            serverSocket.setReuseAddress(true);
            t = new Terminal(serverSocket);
            this.user = t.readLine("Username: ");
            this.password = t.readPassword("Password: ");
            while (this.user == null || this.password == null) {
                t.println(text);
                this.user = t.readLine("Username:");
                this.password = t.readPassword("Password:");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (t != null) {
                t.close();
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void clear() {
        this.user = null;
        if (this.password != null) {
            Arrays.fill(this.password, 'x');
        }
    }
}

