/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import net.e6tech.elements.common.util.Terminal;
import net.e6tech.elements.security.vault.Credential;

public class DualEntry {
    Credential user1;
    Credential user2;
    boolean newUserMode = false;

    public DualEntry() {
    }

    public DualEntry(String user, char[] password) {
        this.user1 = new Credential(user, password);
    }

    public DualEntry(String user, char[] password, String user2, char[] password2) {
        this.user1 = new Credential(user, password);
        this.user2 = new Credential(user2, password2);
    }

    public boolean isNewUserMode() {
        return this.newUserMode;
    }

    public void setNewUserMode(boolean newUserMode) {
        this.newUserMode = newUserMode;
    }

    public void setUser1(Credential user1) {
        this.user1 = user1;
    }

    public void setUser2(Credential user2) {
        this.user2 = user2;
    }

    public void run(String text, int port) {
        while (!this._run(text, port)) {
        }
    }

    public void run(String text, ServerSocket serverSocket) {
        Terminal terminal = new Terminal();
        while (!this._user1(terminal, text)) {
        }
        while (!this._user2(terminal, serverSocket)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _run(String text, int port) {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(port);
            serverSocket.setReuseAddress(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Terminal terminal = new Terminal();
        if (!this._user1(terminal, text)) {
            return false;
        }
        try {
            boolean bl = this._user2(terminal, serverSocket);
            return bl;
        }
        catch (Exception ex) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean _user1(Terminal terminal, String text) {
        if (this.user1 == null || this.user2 == null || this.user1.getUser() == null || this.user2.getUser() == null) {
            terminal.println(text);
        }
        if (this.user1 == null || this.user1.getUser() == null) {
            try {
                String u1 = terminal.readLine("Username: ");
                char[] pwd = terminal.readPassword("Password: ");
                if (!this.verifyPassword(terminal, pwd)) {
                    return false;
                }
                if (u1.length() > 0 && pwd.length > 0) {
                    this.user1 = new Credential(u1, pwd);
                }
            }
            catch (Exception ex) {
                terminal.println("Error getting user name and password: " + ex.getMessage());
                throw ex;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _user2(Terminal terminal, ServerSocket serverSocket) {
        while (this.user2 == null || this.user2.getUser() == null) {
            terminal.println("Please have user2 connect to port " + serverSocket.getLocalPort() + " to provide user name and password");
            Terminal t = null;
            try {
                t = new Terminal(serverSocket);
                String u2 = t.readLine("Username:");
                char[] pwd = t.readPassword("Password:");
                if (u2 == null || pwd == null) {
                    terminal.println("Connection to user2 reset.");
                    continue;
                }
                while (u2.equalsIgnoreCase(this.user1.getUser()) || u2.length() == 0 || pwd.length == 0) {
                    if (u2.equalsIgnoreCase(this.user1.getUser())) {
                        t.println("user1 cannot be the same as user2...try again\n");
                    } else if (u2.length() == 0) {
                        t.println("user name is empty...try again\n");
                    } else if (pwd.length == 0) {
                        t.println("password is empty...try again\n");
                    }
                    u2 = t.readLine("Username:");
                    pwd = t.readPassword("Password:");
                }
                if (!this.verifyPassword(t, pwd)) {
                    boolean bl = false;
                    return bl;
                }
                if (u2.length() <= 0 || pwd.length <= 0) continue;
                this.user2 = new Credential(u2, pwd);
            }
            catch (Exception e) {
                terminal.println("Error getting user2 name and password: " + e.getMessage());
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        return true;
    }

    private boolean verifyPassword(Terminal terminal, char[] pwd) {
        char[] pwd2;
        if (this.newUserMode && !Arrays.equals(pwd, pwd2 = terminal.readPassword("Retype password: "))) {
            terminal.println("Passwords do not match");
            return false;
        }
        return true;
    }

    public Credential getUser1() {
        return this.user1;
    }

    public Credential getUser2() {
        return this.user2;
    }

    public void clear() {
        if (this.user1 != null) {
            this.user1.clear();
        }
        if (this.user2 != null) {
            this.user2.clear();
        }
        this.user2 = null;
        this.user1 = null;
    }
}

