/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.RNG;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SymmetricCipher {
    static volatile boolean initialized = false;
    static final Logger logger = Logger.getLogger();
    private String algorithm = "AES";
    private String transformation = this.algorithm + "/CBC/PKCS7PADDING";
    private int keyLength = 256;
    private boolean base64 = false;

    public static SymmetricCipher getInstance(String algorithm) {
        if ("AES".equalsIgnoreCase(algorithm)) {
            return new SymmetricCipher("AES");
        }
        throw new IllegalArgumentException(algorithm + " is not supported");
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
            Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
            Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
            Field isRestrictedField = jceSecurity.getDeclaredField("isRestricted");
            isRestrictedField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            int origMod = isRestrictedField.getModifiers();
            modifiersField.setInt(isRestrictedField, isRestrictedField.getModifiers() & 0xFFFFFFEF);
            isRestrictedField.set(null, false);
            modifiersField.setInt(isRestrictedField, origMod);
            Field defaultPolicyField = jceSecurity.getDeclaredField("defaultPolicy");
            defaultPolicyField.setAccessible(true);
            PermissionCollection defaultPolicy = (PermissionCollection)defaultPolicyField.get(null);
            Field perms = cryptoPermissions.getDeclaredField("perms");
            perms.setAccessible(true);
            ((Map)perms.get(defaultPolicy)).clear();
            Field instance = cryptoAllPermission.getDeclaredField("INSTANCE");
            instance.setAccessible(true);
            defaultPolicy.add((Permission)instance.get(null));
            logger.info("Successfully removed cryptography restrictions");
        }
        catch (Exception e) {
            logger.warn("Failed to remove cryptography restrictions", (Throwable)e);
        }
    }

    public boolean isBase64() {
        return this.base64;
    }

    public void setBase64(boolean base64) {
        this.base64 = base64;
    }

    public static byte[] toBytes(String hexString) {
        return DatatypeConverter.parseHexBinary((String)hexString);
    }

    public static String toString(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    protected SymmetricCipher(String algorithm) {
        this.algorithm = algorithm;
        this.transformation = algorithm + "/CBC/PKCS7PADDING";
    }

    public String encrypt(SecretKey key, byte[] plain, String iv) throws GeneralSecurityException {
        byte[] ivBytes = null;
        if (iv != null) {
            ivBytes = this.base64 ? Base64.getDecoder().decode(iv) : Hex.toBytes(iv);
        }
        byte[] encrypted = this.encryptBytes(key, plain, ivBytes);
        if (this.base64) {
            return Base64.getEncoder().encodeToString(encrypted);
        }
        return Hex.toString(encrypted);
    }

    public byte[] encryptBytes(SecretKey key, byte[] plain, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.transformation, "BC");
        if (iv != null) {
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
        } else {
            iv = new byte[16];
            for (int i = 0; i < iv.length; ++i) {
                iv[i] = 0;
            }
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
        }
        return cipher.doFinal(plain);
    }

    public byte[] decrypt(SecretKey key, String encrypted, String iv) throws GeneralSecurityException {
        byte[] ivBytes = null;
        if (iv != null) {
            ivBytes = this.base64 ? Base64.getDecoder().decode(iv) : Hex.toBytes(iv);
        }
        byte[] decodedBytes = null;
        decodedBytes = this.base64 ? Base64.getDecoder().decode(encrypted) : Hex.toBytes(encrypted);
        return this.decryptBytes(key, decodedBytes, ivBytes);
    }

    public byte[] decryptBytes(SecretKey key, byte[] encrypted, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.transformation, "BC");
        if (iv != null) {
            cipher.init(2, (Key)key, new IvParameterSpec(iv));
        } else {
            iv = new byte[16];
            for (int i = 0; i < iv.length; ++i) {
                iv[i] = 0;
            }
            cipher.init(2, (Key)key, new IvParameterSpec(iv));
        }
        return cipher.doFinal(encrypted);
    }

    public SecretKey generateKeySpec() {
        KeyGenerator keyGen = null;
        try {
            keyGen = KeyGenerator.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        keyGen.init(this.keyLength);
        SecretKey secretKey = keyGen.generateKey();
        return secretKey;
    }

    public SecretKey getKeySpec(byte[] bytes) {
        return new SecretKeySpec(bytes, this.algorithm);
    }

    public byte[] generateIVBytes() {
        return RNG.generateSeed(16);
    }

    public String generateIV() {
        byte[] iv = this.generateIVBytes();
        if (this.base64) {
            return Base64.getEncoder().encodeToString(iv);
        }
        return Hex.toString(iv);
    }

    public static void main(String ... args) {
    }

    static {
        SymmetricCipher.initialize();
    }
}

