/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.rules;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.rules.ControlFlow;
import net.e6tech.elements.rules.FailedRule;
import net.e6tech.elements.rules.Result;
import net.e6tech.elements.rules.Rule;
import net.e6tech.elements.rules.RuleSet;
import net.e6tech.elements.rules.Verify;
import org.codehaus.groovy.runtime.InvokerHelper;

public class RuleContext
implements GroovyObject {
    private static final String RULE_FAILED_MSG = "Rule failed: ";
    static Logger logger = Logger.getLogger();
    Result result = new Result();
    Rule currentRule;
    boolean completed = false;
    private transient Object delegate;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Rule> rulesHalted = new LinkedHashMap<String, Rule>();
    private Map<String, Rule> rulesExecuted = new LinkedHashMap<String, Rule>();
    private List<FailedRule> failedRules = new LinkedList<FailedRule>();
    private String failedMessage;
    private Throwable exception;
    private RuleSet ruleSet;

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public Result getResult() {
        return this.result;
    }

    public Rule getCurrentRule() {
        return this.currentRule;
    }

    public void setCurrentRule(Rule rule) {
        this.currentRule = rule;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getFailedMessage() {
        return this.failedMessage;
    }

    public void setFailedMessage(String failedMessage) {
        this.failedMessage = failedMessage;
    }

    protected void onCheckFailed() {
    }

    void ruleExecuted(Rule rule) {
        this.rulesExecuted.put(rule.getName(), rule);
    }

    void ruleHalted(Rule rule) {
        this.rulesHalted.put(rule.getName(), rule);
    }

    void ruleFailed(Rule rule, String failedMessage) {
        String message = failedMessage == null ? RULE_FAILED_MSG + rule.getName() + "." : RULE_FAILED_MSG + rule.getName() + " - " + failedMessage;
        if (this.failedMessage == null) {
            this.failedMessage = message;
        }
        this.failedRules.add(new FailedRule(rule, message));
    }

    void ruleFailed(Rule rule, Throwable throwable) {
        this.exception = throwable;
        String message = null;
        message = throwable == null ? RULE_FAILED_MSG + rule.getName() + "." : RULE_FAILED_MSG + rule.getName() + " - " + throwable.getMessage();
        if (this.failedMessage == null) {
            this.failedMessage = message;
        }
        this.failedRules.add(new FailedRule(rule, throwable, message));
        if (throwable != null) {
            logger.debug(throwable.getMessage(), throwable);
        }
    }

    public Rule getRuleExecuted(String ruleName) {
        return this.rulesExecuted.get(ruleName);
    }

    public Rule getRuleHalted(String ruleName) {
        return this.rulesHalted.get(ruleName);
    }

    public Rule getRuleFailed() {
        return this.failedRules.isEmpty() ? null : this.failedRules.get(0).getRule();
    }

    public Throwable getException() {
        return this.exception;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    protected ControlFlow verifyObject(Object object) {
        return ControlFlow.Continue;
    }

    public ControlFlow verify(Object ... objects) {
        ControlFlow flow = ControlFlow.Continue;
        for (Object value : objects) {
            if (value instanceof Closure) {
                Closure c1 = (Closure)((Closure)value).clone();
                c1.setResolveStrategy(1);
                c1.setDelegate((Object)this);
                Object obj = c1.call();
                flow = this.interpret(obj);
            } else if (value instanceof Verify) {
                Verify verify = (Verify)value;
                Closure c1 = (Closure)verify.getClosure().clone();
                c1.setResolveStrategy(1);
                c1.setDelegate((Object)this);
                Object obj = c1.call();
                flow = this.interpret(obj);
            } else {
                flow = value instanceof Boolean ? this.interpret(value) : this.verifyObject(value);
            }
            if (flow != ControlFlow.Failed) continue;
            this.onCheckFailed();
            this.ruleFailed(this.currentRule, "failed to verify rule " + this.currentRule.getName() + " -> " + value);
            break;
        }
        return flow;
    }

    private ControlFlow interpret(Object obj) {
        ControlFlow flow = ControlFlow.Continue;
        if (obj == null) {
            flow = ControlFlow.Continue;
        } else if (obj.getClass().equals(Boolean.TYPE) || obj.getClass().equals(Boolean.class)) {
            boolean bool = (Boolean)obj;
            if (!bool) {
                flow = ControlFlow.Failed;
            }
        } else if (obj instanceof ControlFlow) {
            flow = (ControlFlow)((Object)obj);
        }
        return flow;
    }

    protected void handleFailed(Closure closure) {
        this.onCheckFailed();
        if (closure != null) {
            Closure c1 = (Closure)closure.clone();
            c1.setResolveStrategy(1);
            c1.setDelegate((Object)this);
            c1.run();
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Object getProperty(String property) {
        if ("result".equals(property)) {
            return this.getResult();
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object newValue) {
        this.properties.put(property, newValue);
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return this.getMetaClass().invokeMethod((Object)this, name, args);
        }
        catch (MissingMethodException ex) {
            if (this.delegate != null) {
                MetaClass meta = InvokerHelper.getMetaClass(this.delegate.getClass());
                return meta.invokeMethod(this.delegate, name, args);
            }
            throw ex;
        }
    }

    public MetaClass getMetaClass() {
        return InvokerHelper.getMetaClass(this.getClass());
    }

    public void setMetaClass(MetaClass metaClass) {
        throw new UnsupportedOperationException();
    }
}

