/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.rules;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.jmx.stat.Measurement;
import net.e6tech.elements.rules.ControlFlow;
import net.e6tech.elements.rules.RuleContext;
import net.e6tech.elements.rules.RuleSet;
import net.e6tech.elements.rules.Verify;

public class Rule {
    String name;
    String description;
    Closure condition;
    Closure halted;
    Closure proceed;
    Closure failed;
    List<Object> verifies = new ArrayList<Object>();
    Rule parent;
    RuleSet ruleSet;
    Measurement measurement = new Measurement();

    public void addChild(Rule rule) {
        rule.setParent(this);
        this.verifies.add(rule);
    }

    public boolean removeChild(Rule rule) {
        Iterator<Object> iterator = this.verifies.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object.equals(rule)) {
                iterator.remove();
            }
            removed = true;
        }
        return removed;
    }

    public Rule[] getChildren() {
        ArrayList<Rule> list = new ArrayList<Rule>();
        for (Object object : this.verifies) {
            if (!(object instanceof Rule)) continue;
            list.add((Rule)object);
        }
        return list.toArray(new Rule[list.size()]);
    }

    public Rule getParent() {
        return this.parent;
    }

    public void setParent(Rule parent) {
        this.parent = parent;
    }

    public String ruleName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.description == null) {
            this.description = name;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void verify(Object ... objects) {
        this.verifies.add(objects);
    }

    public void verify(String name, Closure closure) {
        this.verifies.add(new Verify(name, closure));
    }

    public void condition(Closure closure) {
        this.condition = closure;
    }

    public void proceed(Closure closure) {
        this.proceed = closure;
    }

    public void halted(Closure closure) {
        this.halted = closure;
    }

    public void failed(Closure closure) {
        this.failed = closure;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected void measurement(boolean b) {
        this.measurement.setEnabled(b);
    }

    public Rule rule(String name, Closure closure) {
        Rule rule = this.ruleSet.createRule(name, closure, true);
        this.addChild(rule);
        return rule;
    }

    public Rule rule(String name) {
        Rule rule = this.ruleSet.getRule(name);
        this.addChild(rule);
        return rule;
    }

    public void run(RuleContext context) {
        boolean result = this.runInternal(context, true) == ControlFlow.Failed;
        context.setCompleted(!result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ControlFlow runInternal(RuleContext context, boolean root) {
        long start = System.currentTimeMillis();
        boolean cond = true;
        context.setCurrentRule(this);
        if (this.condition != null) {
            Closure c1 = (Closure)this.condition.clone();
            c1.setResolveStrategy(1);
            c1.setDelegate((Object)context);
            try {
                Object obj = c1.call();
                if (obj == null) {
                    cond = true;
                } else if (obj.getClass().equals(Boolean.TYPE) || obj.getClass().equals(Boolean.class)) {
                    cond = (Boolean)obj;
                } else if (ControlFlow.Failed == obj) {
                    cond = false;
                }
            }
            catch (Exception ex) {
                return this.handleException(context, ex);
            }
        }
        ControlFlow flow = ControlFlow.Continue;
        if (cond) {
            Exception exception = null;
            for (Object object : this.verifies) {
                context.setCurrentRule(this);
                if (object instanceof Rule) {
                    Rule child = (Rule)object;
                    if (flow == ControlFlow.Failed || flow == ControlFlow.Success) {
                        context.ruleHalted(child);
                        continue;
                    }
                    if (flow != ControlFlow.Continue) continue;
                    try {
                        flow = child.runInternal(context, false);
                    }
                    catch (Exception ex) {
                        context.ruleHalted(child);
                        flow = ControlFlow.Failed;
                        exception = ex;
                    }
                    continue;
                }
                if (flow != ControlFlow.Continue) continue;
                try {
                    context.setCurrentRule(this);
                    if (object instanceof Object[]) {
                        Object[] verifyObjects = (Object[])object;
                        flow = context.verify(verifyObjects);
                        continue;
                    }
                    flow = context.verify(object);
                }
                catch (Exception ex) {
                    flow = ControlFlow.Failed;
                    exception = ex;
                }
            }
            try {
                context.setCurrentRule(this);
                if (flow == ControlFlow.Failed) {
                    if (exception != null) {
                        this.handleException(context, exception);
                    } else {
                        this.runClosure(context, this.failed);
                        if (this.measurement != null) {
                            this.measurement.fail();
                        }
                    }
                    context.setCompleted(false);
                    context.ruleHalted(this);
                    return ControlFlow.Failed;
                }
                this.runClosure(context, this.proceed);
                context.ruleExecuted(this);
                if (this.measurement == null) return flow;
                this.measurement.append((double)(System.currentTimeMillis() - start));
                return flow;
            }
            catch (Exception ex) {
                return this.handleException(context, ex);
            }
        }
        try {
            this.runClosure(context, this.halted);
            context.ruleHalted(this);
            return flow;
        }
        catch (Exception ex) {
            return this.handleException(context, ex);
        }
    }

    private ControlFlow handleException(RuleContext context, Exception throwable) {
        if (this.measurement != null) {
            this.measurement.fail();
        }
        context.setCurrentRule(this);
        try {
            this.runClosure(context, this.failed);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception th) {
            throw new SystemException((Throwable)th);
        }
        context.ruleFailed(this, throwable);
        return ControlFlow.Failed;
    }

    private void runClosure(RuleContext context, Closure closure) {
        if (closure == null) {
            return;
        }
        Closure a1 = (Closure)closure.clone();
        a1.setResolveStrategy(1);
        a1.setDelegate((Object)context);
        a1.run();
    }
}

