/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.rules;

import groovy.lang.Closure;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.script.ScriptException;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.script.AbstractScriptShell;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.jmx.JMXService;
import net.e6tech.elements.rules.Rule;
import net.e6tech.elements.rules.RuleContext;

public class RuleSet
extends AbstractScriptShell {
    private static final String DEFAULT = "default";
    private static Logger logger = Logger.getLogger();
    private Map<String, Rule> rules;
    private Rule root;
    private Map<String, Rule> rootSet = new LinkedHashMap<String, Rule>();
    private Map<String, Map<String, Rule>> rootRules = new LinkedHashMap<String, Map<String, Rule>>();
    private boolean measurement = false;
    private String mbeanPrefix = "";

    public RuleSet(Properties properties) {
        super(properties);
    }

    public RuleSet(ResourceManager resourceManager) {
        this(null, resourceManager);
    }

    public RuleSet(String beanName, ResourceManager resourceManager) {
        super(resourceManager.getProperties());
        this.setKnownEnvironments(resourceManager.getKnownEnvironments());
        if (beanName != null) {
            resourceManager.registerBean(beanName, (Object)this);
        }
    }

    public String getMbeanPrefix() {
        return this.mbeanPrefix;
    }

    public void setMbeanPrefix(String mbeanPrefix) {
        this.mbeanPrefix = mbeanPrefix;
    }

    public void loadRoots(String ... rootSet) throws ScriptException {
        for (String rt : rootSet) {
            this.load(rt);
        }
    }

    public synchronized void load(String str) throws ScriptException {
        this.rules = new LinkedHashMap<String, Rule>();
        super.load(str);
        this.registerMBean(this.getMbeanPrefix(), this.root);
        this.root = null;
        this.rules = null;
    }

    protected void registerMBean(String path, Rule rule) {
        if (!this.measurement) {
            return;
        }
        if (rule.getMeasurement() != null) {
            rule.getMeasurement().setName(rule.getName());
            rule.getMeasurement().setUnit("ms");
            String objectName = "net.e6tech:type=Rule,name=" + path + rule.getName();
            JMXService.registerMBean((Object)rule.getMeasurement(), (String)objectName);
        }
        String contextPath = path + rule.getName() + ".";
        for (Rule child : rule.getChildren()) {
            this.registerMBean(contextPath, child);
        }
    }

    public Rule createRule(String name, Closure closure, boolean anonymous) {
        Rule rule = new Rule();
        rule.setRuleSet(this);
        rule.setName(name);
        rule.measurement(this.measurement);
        closure.setDelegate((Object)rule);
        closure.setResolveStrategy(1);
        closure.run();
        if (!anonymous) {
            this.addRule(rule);
        }
        return rule;
    }

    public void addRoot(String ruleSetName, Rule root) {
        String ruleSet = ruleSetName;
        if (ruleSet == null || DEFAULT.equalsIgnoreCase(ruleSet.trim())) {
            ruleSet = DEFAULT;
        }
        this.rootSet.put(ruleSet, root);
        this.rootRules.put(ruleSet, this.rules);
        this.root = root;
    }

    void addRule(Rule rule) {
        if (this.rules.get(rule.getName()) != null) {
            throw new SystemException("Duplicate rule name: " + rule.getName());
        }
        this.rules.put(rule.getName(), rule);
    }

    Rule getRule(String key) {
        return this.rules.get(key);
    }

    public Optional<Rule> getRoot(String ruleSetName) {
        String ruleSet = ruleSetName;
        if (this.rootSet.size() == 0) {
            throw new SystemException("root not set");
        }
        if (ruleSet == null || DEFAULT.equalsIgnoreCase(ruleSet.trim())) {
            ruleSet = DEFAULT;
        }
        return Optional.ofNullable(this.rootSet.get(ruleSet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRule(String ruleSetName, RuleContext context) {
        String ruleSet = ruleSetName;
        if (this.rootSet.size() == 0) {
            throw new SystemException("root not set");
        }
        if (ruleSet == null || DEFAULT.equalsIgnoreCase(ruleSet.trim())) {
            ruleSet = DEFAULT;
        }
        if (this.rootSet.get(ruleSet) == null) {
            throw new SystemException("ruleSet " + ruleSet + " not found");
        }
        try {
            context.setRuleSet(this);
            context.getProperties().putAll(this.getScripting().getVariables());
            this.rootSet.get(ruleSet).run(context);
        }
        finally {
            context.setRuleSet(null);
        }
    }

    public RuleSet measurement(boolean b) {
        this.measurement = b;
        return this;
    }

    public boolean measurement() {
        return this.measurement;
    }

    public String log() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Rule> entry : this.rootSet.entrySet()) {
            String ruleName = entry.getKey();
            builder.append("\nRoot (").append(ruleName).append(")\n");
            this._log(entry.getValue(), builder, 1);
        }
        String str = builder.toString();
        logger.info(str);
        return str;
    }

    private void _log(Rule rule, StringBuilder builder, int indent) {
        for (Object object : rule.verifies) {
            for (int i = 0; i < indent; ++i) {
                builder.append("  ");
            }
            if (object instanceof Rule) {
                builder.append("- ");
                Rule child = (Rule)object;
                String ruleName = child.getName();
                builder.append(ruleName).append("\n");
                this._log(child, builder, indent + 1);
                continue;
            }
            if (object instanceof Object[]) {
                builder.append("  verify ");
                Object[] objects = (Object[])object;
                boolean first = true;
                for (Object obj : objects) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(obj);
                }
                builder.append("\n");
                continue;
            }
            builder.append("  verify ");
            builder.append(object).append("\n");
        }
    }
}

