/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.rules;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import java.util.HashMap;
import java.util.Map;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.rules.ControlFlow;
import net.e6tech.elements.rules.Result;
import net.e6tech.elements.rules.Rule;
import net.e6tech.elements.rules.Verify;
import org.codehaus.groovy.runtime.InvokerHelper;

public class RuleContext
implements GroovyObject {
    static Logger logger = Logger.getLogger();
    Result result = new Result();
    Rule currentRule;
    boolean completed = false;
    private transient Object delegate;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Rule> rulesHalted = new HashMap<String, Rule>();
    private Map<String, Rule> rulesExecuted = new HashMap<String, Rule>();
    private Rule ruleFailed;
    private String failedMessage;
    private Throwable exception;

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public Result getResult() {
        return this.result;
    }

    public Rule getCurrentRule() {
        return this.currentRule;
    }

    public void setCurrentRule(Rule rule) {
        this.currentRule = rule;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    protected void onCheckFailed() {
    }

    void ruleExecuted(Rule rule) {
        this.rulesExecuted.put(rule.getName(), rule);
    }

    void ruleHalted(Rule rule) {
        this.rulesHalted.put(rule.getName(), rule);
    }

    void ruleFailed(Rule rule, String failedMessage) {
        this.ruleFailed = rule;
        this.failedMessage = failedMessage == null ? "Rule failed: " + rule.getName() + "." : "Rule failed: " + rule.getName() + " - " + failedMessage;
    }

    void ruleFailed(Rule rule, Throwable throwable) {
        this.exception = throwable;
        this.ruleFailed = rule;
        this.failedMessage = this.failedMessage == null ? "Rule failed: " + rule.getName() + "." : "Rule failed: " + rule.getName() + " - " + throwable.getMessage();
        logger.debug(throwable.getMessage(), throwable);
    }

    public Rule getRuleExecuted(String ruleName) {
        return this.rulesExecuted.get(ruleName);
    }

    public Rule getRuleHalted(String ruleName) {
        return this.rulesHalted.get(ruleName);
    }

    public Rule getRuleFailed() {
        return this.ruleFailed;
    }

    public String getFailedMessage() {
        return this.failedMessage;
    }

    public Throwable getException() {
        return this.exception;
    }

    protected ControlFlow verifyObject(Object object) {
        return ControlFlow.Continue;
    }

    public ControlFlow verify(Object ... objects) {
        ControlFlow flow = ControlFlow.Continue;
        for (Object value : objects) {
            if (value instanceof Closure) {
                Closure c1 = (Closure)((Closure)value).clone();
                c1.setResolveStrategy(1);
                c1.setDelegate((Object)this);
                Object obj = c1.call();
                flow = this.interpret(obj);
            } else if (value instanceof Verify) {
                Verify verify = (Verify)value;
                Closure c1 = (Closure)verify.getClosure().clone();
                c1.setResolveStrategy(1);
                c1.setDelegate((Object)this);
                Object obj = c1.call();
                flow = this.interpret(obj);
            } else {
                flow = value instanceof Boolean ? this.interpret(value) : this.verifyObject(value);
            }
            if (flow != ControlFlow.Failed) continue;
            this.onCheckFailed();
            this.ruleFailed(this.currentRule, "failed to verify rule " + this.currentRule.getName() + " -> " + value);
            break;
        }
        return flow;
    }

    private ControlFlow interpret(Object obj) {
        ControlFlow flow = ControlFlow.Continue;
        if (obj == null) {
            flow = ControlFlow.Continue;
        } else if (obj.getClass().equals(Boolean.TYPE) || obj.getClass().equals(Boolean.class)) {
            boolean bool = (Boolean)obj;
            if (!bool) {
                flow = ControlFlow.Failed;
            }
        } else if (obj instanceof ControlFlow) {
            flow = (ControlFlow)((Object)obj);
        }
        return flow;
    }

    protected void handleFailed(Closure closure) {
        this.onCheckFailed();
        if (closure != null) {
            Closure c1 = (Closure)closure.clone();
            c1.setResolveStrategy(1);
            c1.setDelegate((Object)this);
            c1.run();
        }
    }

    public Object getProperty(String property) {
        if (property.equals("result")) {
            return this.getResult();
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object newValue) {
        this.properties.put(property, newValue);
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return this.getMetaClass().invokeMethod((Object)this, name, args);
        }
        catch (MissingMethodException ex) {
            if (this.delegate != null) {
                MetaClass meta = InvokerHelper.getMetaClass(this.delegate.getClass());
                return meta.invokeMethod(this.delegate, name, args);
            }
            throw ex;
        }
    }

    public MetaClass getMetaClass() {
        return InvokerHelper.getMetaClass(this.getClass());
    }

    public void setMetaClass(MetaClass metaClass) {
        throw new UnsupportedOperationException();
    }
}

