/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.rules;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.e6tech.elements.jmx.stat.Measurement;
import net.e6tech.elements.rules.RuleContext;
import net.e6tech.elements.rules.RuleSet;
import net.e6tech.elements.rules.Verify;

public class Rule {
    String name;
    String description;
    Closure condition;
    Closure halt;
    Closure proceed;
    Closure failed;
    List<Object> verifies = new ArrayList<Object>();
    Rule parent;
    RuleSet ruleSet;
    Measurement measurement = new Measurement();

    public void addChild(Rule rule) {
        rule.setParent(this);
        this.verifies.add(rule);
    }

    public boolean removeChild(Rule rule) {
        Iterator<Object> iterator = this.verifies.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object.equals(rule)) {
                iterator.remove();
            }
            removed = true;
        }
        return removed;
    }

    public Rule[] getChildren() {
        ArrayList<Rule> list = new ArrayList<Rule>();
        for (Object object : this.verifies) {
            if (!(object instanceof Rule)) continue;
            list.add((Rule)object);
        }
        return list.toArray(new Rule[list.size()]);
    }

    public Rule getParent() {
        return this.parent;
    }

    public void setParent(Rule parent) {
        this.parent = parent;
    }

    public String ruleName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.description == null) {
            this.description = name;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void verify(Object ... objects) {
        this.verifies.add(objects);
    }

    public void verify(String name, Closure closure) {
        this.verifies.add(new Verify(name, closure));
    }

    public void condition(Closure closure) {
        this.condition = closure;
    }

    public void proceed(Closure closure) {
        this.proceed = closure;
    }

    public void halt(Closure closure) {
        this.halt = closure;
    }

    public void failed(Closure closure) {
        this.failed = closure;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public Rule rule(String name, Closure closure) {
        Rule rule = this.ruleSet.createRule(name, closure, true);
        this.addChild(rule);
        return rule;
    }

    public Rule rule(String name) {
        Rule rule = this.ruleSet.getRule(name);
        this.addChild(rule);
        return rule;
    }

    public void run(RuleContext context) {
        this._run(context, true);
    }

    private boolean _run(RuleContext context, boolean root) {
        long start = System.currentTimeMillis();
        boolean bool = true;
        if (this.condition != null) {
            Closure c1 = (Closure)this.condition.clone();
            c1.setResolveStrategy(1);
            c1.setDelegate((Object)context);
            try {
                Object obj = c1.call();
                if (obj == null) {
                    bool = true;
                } else if (obj.getClass().equals(Boolean.TYPE) || obj.getClass().equals(Boolean.class)) {
                    bool = (Boolean)obj;
                }
            }
            catch (AssertionError ex) {
                return this.handleFailed(context, root, ex);
            }
        }
        if (bool) {
            AssertionError error = null;
            Object failedObject = null;
            for (Object object : this.verifies) {
                if (object instanceof Rule) {
                    Rule child = (Rule)object;
                    if (error != null) {
                        context.ruleHalted(child);
                        continue;
                    }
                    try {
                        child._run(context, false);
                    }
                    catch (AssertionError ex) {
                        error = ex;
                        failedObject = child;
                        context.ruleHalted(child);
                    }
                    continue;
                }
                if (error != null) continue;
                try {
                    context.setCurrentRule(this);
                    if (object instanceof Object[]) {
                        Object[] verifyObjects = (Object[])object;
                        bool = context.verify(verifyObjects);
                        continue;
                    }
                    bool = context.verify(object);
                }
                catch (AssertionError ex) {
                    error = ex;
                    failedObject = object;
                }
            }
            if (error != null) {
                this.runClosure(context, this.failed);
                if (failedObject instanceof Rule) {
                    if (this.measurement != null) {
                        this.measurement.fail();
                    }
                    if (!root) {
                        throw error;
                    }
                    return false;
                }
                return this.handleFailed(context, root, error);
            }
        }
        context.setCurrentRule(this);
        try {
            if (bool) {
                this.runClosure(context, this.proceed);
                context.ruleExecuted(this);
                if (this.measurement != null) {
                    this.measurement.add((double)(System.currentTimeMillis() - start));
                }
            } else {
                this.runClosure(context, this.halt);
                context.ruleHalted(this);
            }
        }
        catch (AssertionError ex) {
            return this.handleFailed(context, root, ex);
        }
        context.setCompleted(true);
        return true;
    }

    private boolean handleFailed(RuleContext context, boolean root, AssertionError error) {
        if (this.measurement != null) {
            this.measurement.fail();
        }
        context.setCurrentRule(this);
        context.setCompleted(false);
        this.runClosure(context, this.failed);
        context.ruleFailed(this, ((Throwable)((Object)error)).getMessage());
        if (!root) {
            throw error;
        }
        return false;
    }

    private void runClosure(RuleContext context, Closure closure) {
        if (closure == null) {
            return;
        }
        try {
            Closure a1 = (Closure)closure.clone();
            a1.setResolveStrategy(1);
            a1.setDelegate((Object)context);
            a1.run();
        }
        catch (AssertionError ex) {
            if (closure == this.failed) {
                return;
            }
            throw ex;
        }
        catch (Throwable throwable) {
            if (closure == this.failed) {
                return;
            }
            throw new AssertionError((Object)throwable);
        }
    }
}

