/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.reporting;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.reporting.Print;
import net.e6tech.elements.reporting.ReportInfo;
import net.e6tech.elements.reporting.text.TextReportingImpl;

public abstract class Reporting {
    private String baseDir = "";

    public static Reporting getInstance() {
        return new TextReportingImpl();
    }

    public static Reporting getInstance(String engine) {
        if (!engine.equals("text")) {
            throw new IllegalArgumentException("Unsupported reporting engine: " + engine);
        }
        return new TextReportingImpl();
    }

    public Reporting() {
    }

    public Reporting(String baseDir) {
        this.setBaseDir(baseDir);
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public Reporting baseDir(String baseDir) {
        this.setBaseDir(baseDir);
        return this;
    }

    public void setBaseDir(String baseDir) {
        if (baseDir != null && baseDir.trim().length() != 0) {
            this.baseDir = !baseDir.endsWith(File.separator) && !baseDir.endsWith("/") ? baseDir.trim() + "/" : baseDir.trim();
        }
    }

    protected ReportInfo info(String path) {
        return new ReportInfo(this.getBaseDir(), path);
    }

    public abstract Object loadObject(String var1) throws IOException;

    public abstract Print report(String var1, Map<String, Object> var2, List var3) throws IOException;
}

