/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.reporting;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;

public class ReportInfo
implements Cloneable {
    private String baseDir = "";
    private String fullPath;
    private String fileName;
    private String extension;
    private long timeStamp;
    private Object value;
    private boolean classpath = false;

    public ReportInfo(String baseDir, String file) {
        if (baseDir == null) {
            baseDir = "";
        }
        this.baseDir = baseDir.trim();
        this.init(file);
    }

    public void init(String file) {
        File f;
        String name;
        int idx;
        this.fullPath = file;
        if (this.baseDir != null && this.baseDir.length() > 0) {
            while (this.fullPath.startsWith(File.separator) || this.fullPath.startsWith("/")) {
                this.fullPath = this.fullPath.substring(1);
            }
            this.fullPath = this.baseDir + this.fullPath;
        }
        if ((idx = (name = (f = new File(this.fullPath)).getName()).lastIndexOf(".")) > 0) {
            idx = this.fullPath.lastIndexOf(".");
            this.fileName = this.fullPath.substring(0, idx);
            this.extension = this.fullPath.substring(idx).toLowerCase();
        } else {
            this.fileName = this.fullPath;
            this.extension = "";
        }
        this.exists();
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getName() {
        return this.fileName;
    }

    public String getExtension() {
        return this.extension;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void changeExtension(String ext) {
        if (this.extension.length() > 0) {
            int idx = this.fullPath.lastIndexOf(".");
            if (ext == null || ext.trim().length() == 0) {
                ext = "";
            } else if (!ext.startsWith(".")) {
                ext = "." + ext;
            }
            this.fullPath = this.fullPath.substring(0, idx) + ext;
        }
        this.extension = ext;
        this.exists();
    }

    public ReportInfo withExtension(String ext) {
        ReportInfo info = this.clone();
        info.extension = ext;
        if (this.extension.length() > 0) {
            int idx = this.fullPath.lastIndexOf(".");
            if (ext == null || ext.trim().length() == 0) {
                ext = "";
            } else if (!ext.startsWith(".")) {
                ext = "." + ext;
            }
            info.fullPath = this.fullPath.substring(0, idx) + ext;
        }
        return info;
    }

    public boolean exists() {
        boolean found = false;
        File file = new File(this.getFullPath());
        if (file.exists()) {
            this.classpath = false;
            found = true;
            this.timeStamp = file.lastModified();
        } else if (this.getClass().getClassLoader().getResource(this.getFullPath()) != null) {
            this.classpath = true;
            found = true;
            this.timeStamp = System.currentTimeMillis();
        }
        return found;
    }

    public InputStream getInputStream() throws IOException {
        File file = new File(this.getFullPath());
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return this.getClass().getClassLoader().getResourceAsStream(this.getFullPath());
    }

    public <T> T value(Function<ReportInfo, T> function) {
        if (this.value == null) {
            this.value = function.apply(this);
            return (T)this.value;
        }
        if (this.classpath) {
            return (T)this.value;
        }
        File file = new File(this.getFullPath());
        if (file.lastModified() != this.timeStamp) {
            this.value = function.apply(this);
            this.timeStamp = file.lastModified();
        }
        return (T)this.value;
    }

    protected ReportInfo clone() {
        try {
            return (ReportInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReportInfo)) {
            return false;
        }
        if (this.getName() == null) {
            return false;
        }
        return this.getName().equals(((ReportInfo)obj).getName());
    }
}

