/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.reporting.jasper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.e6tech.elements.reporting.Print;
import net.e6tech.elements.reporting.ReportInfo;
import net.e6tech.elements.reporting.Reporting;
import net.e6tech.elements.reporting.jasper.PrintImpl;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class ReportingImpl
extends Reporting {
    private static Map<String, ReportInfo> cache = new Hashtable<String, ReportInfo>();

    public ReportingImpl() {
    }

    public ReportingImpl(String baseDir) {
        super(baseDir);
    }

    @Override
    public Object loadObject(String path) throws IOException {
        JasperReport report = this.loadReport(path);
        if (report == null) {
            return this.info(path).getFullPath();
        }
        return report;
    }

    protected JasperReport loadReport(String path) throws IOException {
        ReportInfo jrxmlFile;
        ReportInfo reportInfo = this.info(path);
        if (cache.get(reportInfo.getName()) != null) {
            return cache.get(reportInfo.getName()).value(this.getJasperReport());
        }
        if (reportInfo.getExtension().equals(".jasper") && (jrxmlFile = reportInfo.withExtension(".jrxml")).exists() && jrxmlFile.getTimeStamp() > reportInfo.getTimeStamp()) {
            reportInfo = jrxmlFile;
        }
        JasperReport report = null;
        if (reportInfo.exists() && (report = reportInfo.value(this.getJasperReport())) != null) {
            cache.put(reportInfo.getName(), reportInfo);
        }
        return report;
    }

    private Function<ReportInfo, JasperReport> getJasperReport() {
        return info -> {
            ReportInfo jrxmlFile;
            if (info.getExtension().equals(".jasper") && (jrxmlFile = info.withExtension(".jrxml")).exists() && jrxmlFile.getTimeStamp() > info.getTimeStamp()) {
                info = jrxmlFile;
                info.changeExtension(".jrxml");
            }
            try (InputStream in = info.getInputStream();){
                if (info.getExtension().equals(".jrxml")) {
                    JasperReport jasperReport = this.compile(in);
                    return jasperReport;
                }
                if (!info.getExtension().equals(".jasper")) return null;
                JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)in);
                return jasperReport;
            }
            catch (JRException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private JasperReport compile(InputStream in) throws JRException {
        JasperDesign design = JRXmlLoader.load((InputStream)in);
        return JasperCompileManager.compileReport((JasperDesign)design);
    }

    @Override
    public Print report(String mainReport, Map<String, Object> params, List data) throws IOException {
        JasperReport report = this.loadReport(mainReport);
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("Reporting", this);
        try {
            JasperPrint print = JasperFillManager.fillReport((JasperReport)report, params, (JRDataSource)new JRBeanCollectionDataSource((Collection)data));
            return new PrintImpl(print);
        }
        catch (JRException e) {
            throw new IOException(e);
        }
    }
}

