/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.reporting.jasper;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.e6tech.elements.reporting.Print;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleTextExporterConfiguration;
import net.sf.jasperreports.export.SimpleTextReportConfiguration;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.view.JasperViewer;

public class PrintImpl
implements Print {
    private JasperPrint print;

    public PrintImpl(JasperPrint print) {
        this.print = print;
    }

    @Override
    public void exportToPdfFile(String outputFile) throws IOException {
        try {
            JasperExportManager.exportReportToPdfFile((JasperPrint)this.print, (String)outputFile);
        }
        catch (JRException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void exportToPdfStream(OutputStream outputStream) throws IOException {
        try {
            JasperExportManager.exportReportToPdfStream((JasperPrint)this.print, (OutputStream)outputStream);
        }
        catch (JRException e) {
            throw new IOException(e);
        }
        finally {
            outputStream.close();
        }
    }

    @Override
    public void exportToHtmlFile(String outputFile) throws IOException {
        try {
            JasperExportManager.exportReportToHtmlFile((JasperPrint)this.print, (String)outputFile);
        }
        catch (JRException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void exportToTextFile(String outputFile) throws IOException {
        try {
            JRTextExporter exporter = this.buildJRTextExporter();
            File destFile = new File(outputFile);
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.print));
            exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(destFile));
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void exportToTextStream(OutputStream outputStream) throws IOException {
        try {
            JRTextExporter exporter = this.buildJRTextExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.print));
            exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(outputStream));
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new IOException(e);
        }
    }

    private JRTextExporter buildJRTextExporter() {
        JRTextExporter exporter = new JRTextExporter();
        SimpleTextExporterConfiguration textExportConfig = new SimpleTextExporterConfiguration();
        exporter.setConfiguration((ExporterConfiguration)textExportConfig);
        SimpleTextReportConfiguration textReportConfig = new SimpleTextReportConfiguration();
        textReportConfig.setCharHeight(new Float(13.948f));
        textReportConfig.setCharWidth(new Float(7.238f));
        textReportConfig.setPageWidthInChars(new Integer(80));
        textReportConfig.setPageHeightInChars(new Integer(71));
        textReportConfig.setOverrideHints(Boolean.valueOf(false));
        exporter.setConfiguration((ReportExportConfiguration)textReportConfig);
        return exporter;
    }

    @Override
    public void view() {
        JasperViewer.viewReport((JasperPrint)this.print);
    }
}

