/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.mariadb;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverAction;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.e6tech.elements.persist.mariadb.ConnectionListener;
import net.e6tech.elements.persist.mariadb.MariaDbConnectionExt;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.util.DeRegister;
import org.mariadb.jdbc.internal.util.constant.HaMode;
import org.mariadb.jdbc.internal.util.constant.Version;
import org.mariadb.jdbc.util.DefaultOptions;
import org.mariadb.jdbc.util.Options;

public class Driver
implements java.sql.Driver {
    private List<ConnectionListener> listeners = Collections.synchronizedList(new ArrayList());

    public void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        UrlParser urlParser = UrlParser.parse((String)url, (Properties)props);
        if (urlParser == null || urlParser.getHostAddresses() == null) {
            return null;
        }
        if (!this.listeners.isEmpty()) {
            this.listeners.forEach(ConnectionListener::onConnect);
        }
        return MariaDbConnectionExt.newConnection(urlParser, null);
    }

    @Override
    public boolean acceptsURL(String url) {
        return UrlParser.acceptsUrl((String)url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Options options;
        if (url != null && !url.isEmpty()) {
            UrlParser urlParser = UrlParser.parse((String)url, (Properties)info);
            if (urlParser == null || urlParser.getOptions() == null) {
                return new DriverPropertyInfo[0];
            }
            options = urlParser.getOptions();
        } else {
            options = DefaultOptions.parse((HaMode)HaMode.NONE, (String)"", (Properties)info, null);
        }
        ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
        for (DefaultOptions o : DefaultOptions.values()) {
            try {
                Field field = Options.class.getField(o.getOptionName());
                Object value = field.get(options);
                DriverPropertyInfo propertyInfo = new DriverPropertyInfo(field.getName(), value == null ? null : value.toString());
                propertyInfo.description = o.getDescription();
                propertyInfo.required = o.isRequired();
                props.add(propertyInfo);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return props.toArray(new DriverPropertyInfo[props.size()]);
    }

    @Override
    public int getMajorVersion() {
        return Version.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return Version.minorVersion;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Use logging parameters for enabling logging.");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver(), (DriverAction)new DeRegister());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

