/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.persist.EntityManagerConfig;
import net.e6tech.elements.persist.EntityManagerExtension;
import net.e6tech.elements.persist.EntityManagerProvider;
import net.e6tech.elements.persist.EntityManagerSupport;
import net.e6tech.elements.persist.Extension;
import net.e6tech.elements.persist.InvocationListener;
import net.e6tech.elements.persist.Watcher;

public class EntityManagerInvocationHandler
extends Watcher<EntityManager>
implements EntityManagerSupport {
    private static Set<Method> supportMethods = new HashSet<Method>();
    private static Logger logger = Logger.getLogger();
    private Resources resources;
    private String alias;
    private EntityManagerProvider provider;
    private EntityManagerConfig config;
    private InvocationListener<EntityManager> entityManagerListener;
    private InvocationListener<Query> queryListener;
    private EntityManagerExtension proxy;
    private Map<String, Object> context = new HashMap<String, Object>();

    public EntityManagerInvocationHandler(Resources resources, EntityManager em, String alias, EntityManagerProvider provider, EntityManagerConfig config, InvocationListener<EntityManager> entityManagerListener, InvocationListener<Query> queryListener) {
        super(em);
        this.resources = resources;
        this.alias = alias;
        this.provider = provider;
        this.config = config;
        this.entityManagerListener = entityManagerListener;
        this.queryListener = queryListener;
    }

    private static Object doInvoke(Class callingClass, Watcher watcher, InvocationListener listener, InvocationListener<Query> queryListener, Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> returnType;
        Object ret;
        long start;
        block12: {
            start = System.currentTimeMillis();
            ret = null;
            try {
                if (listener != null) {
                    listener.beforeInvocation(callingClass, proxy, method, args);
                }
                ret = method.invoke(watcher.getTarget(), args);
                if (listener == null) break block12;
                listener.afterInvocation(callingClass, proxy, method, args, ret);
            }
            catch (InvocationTargetException ex) {
                try {
                    Logger.suppress((Throwable)ex);
                    if (listener != null) {
                        listener.onException(callingClass, proxy, method, args, ex.getTargetException());
                    }
                    throw ex.getCause();
                }
                catch (Throwable throwable) {
                    Class<?> returnType2;
                    if (logger.isDebugEnabled() && watcher.isMonitorTransaction()) {
                        long duration = System.currentTimeMillis() - start;
                        Class<?> returnType3 = method.getReturnType();
                        if (ret != null && Query.class.isAssignableFrom(returnType3)) {
                            QueryInvocationHandler handler = new QueryInvocationHandler((Query)ret, queryListener);
                            handler.listener = queryListener;
                            handler.setLongTransaction(watcher.getLongTransaction());
                            handler.setIgnoreInitialLongTransactions(watcher.getIgnoreInitialLongTransactions());
                            ret = returnType3.isInterface() ? Proxy.newProxyInstance(watcher.getClass().getClassLoader(), new Class[]{returnType3}, (InvocationHandler)handler) : Proxy.newProxyInstance(watcher.getClass().getClassLoader(), returnType3.getInterfaces(), (InvocationHandler)handler);
                        }
                        watcher.log(method, args, duration);
                    }
                    if (EntityTransaction.class.isAssignableFrom(returnType2 = method.getReturnType())) {
                        TransactionInvocationHandler handler = new TransactionInvocationHandler((EntityManagerInvocationHandler)watcher, (EntityTransaction)ret);
                        ret = Proxy.newProxyInstance(watcher.getClass().getClassLoader(), new Class[]{returnType2}, (InvocationHandler)handler);
                    }
                    throw throwable;
                }
            }
        }
        if (logger.isDebugEnabled() && watcher.isMonitorTransaction()) {
            long duration = System.currentTimeMillis() - start;
            Class<?> returnType4 = method.getReturnType();
            if (ret != null && Query.class.isAssignableFrom(returnType4)) {
                QueryInvocationHandler handler = new QueryInvocationHandler((Query)ret, queryListener);
                handler.listener = queryListener;
                handler.setLongTransaction(watcher.getLongTransaction());
                handler.setIgnoreInitialLongTransactions(watcher.getIgnoreInitialLongTransactions());
                ret = returnType4.isInterface() ? Proxy.newProxyInstance(watcher.getClass().getClassLoader(), new Class[]{returnType4}, (InvocationHandler)handler) : Proxy.newProxyInstance(watcher.getClass().getClassLoader(), returnType4.getInterfaces(), (InvocationHandler)handler);
            }
            watcher.log(method, args, duration);
        }
        if (EntityTransaction.class.isAssignableFrom(returnType = method.getReturnType())) {
            TransactionInvocationHandler handler = new TransactionInvocationHandler((EntityManagerInvocationHandler)watcher, (EntityTransaction)ret);
            ret = Proxy.newProxyInstance(watcher.getClass().getClassLoader(), new Class[]{returnType}, (InvocationHandler)handler);
        }
        return ret;
    }

    @Override
    public Object doInvoke(Class callingClass, Object proxy, Method method, Object[] args) throws Throwable {
        if (supportMethods.contains(method)) {
            return method.invoke((Object)this, args);
        }
        return EntityManagerInvocationHandler.doInvoke(callingClass, this, this.entityManagerListener, this.queryListener, proxy, method, args);
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public EntityManagerProvider getProvider() {
        return this.provider;
    }

    @Override
    public EntityManagerConfig getConfig() {
        return this.config;
    }

    @Override
    public EntityManagerExtension lockTimeout(long millis) {
        this.runExtension("setLockTimeout", millis);
        return this.getProxy();
    }

    @Override
    public long lockTimeout() {
        return (Long)this.runExtension("getLockTimeout", new Object[0]);
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public Object get(String key) {
        return this.context.get(key);
    }

    @Override
    public EntityManagerExtension put(String key, Object value) {
        this.context.put(key, value);
        return this.getProxy();
    }

    @Override
    public EntityManagerExtension remove(String key) {
        this.context.remove(key);
        return this.getProxy();
    }

    private EntityManagerExtension getProxy() {
        if (this.proxy == null) {
            this.proxy = (EntityManagerExtension)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManager.class, EntityManagerExtension.class}, (InvocationHandler)this);
        }
        return this.proxy;
    }

    @Override
    public Object runExtension(String extension, Object ... args) {
        Extension ext = this.provider.getExtensions().get(extension);
        if (ext != null) {
            if (args != null) {
                switch (args.length) {
                    case 0: {
                        return ext.call((Object)this.getProxy());
                    }
                }
                Object[] params = new Object[args.length + 1];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = i == 0 ? this.getProxy() : args[i - 1];
                }
                return ext.call(params);
            }
            return ext.call(this.getTarget());
        }
        return null;
    }

    public void onCommit() {
        this.runExtension("onCommit", new Object[0]);
    }

    public void onAbort() {
        this.runExtension("onAbort", new Object[0]);
    }

    public void onClose() {
        this.runExtension("onClose", new Object[0]);
    }

    static {
        for (Method method : EntityManagerSupport.class.getDeclaredMethods()) {
            supportMethods.add(method);
        }
        for (Method method : EntityManagerInvocationHandler.class.getDeclaredMethods()) {
            supportMethods.add(method);
        }
    }

    public static class TransactionInvocationHandler
    implements InvocationHandler {
        private EntityTransaction transaction;
        private EntityManagerInvocationHandler handler;

        public TransactionInvocationHandler(EntityManagerInvocationHandler handler, EntityTransaction transaction) {
            this.transaction = transaction;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getName().equals("commit")) {
                    this.handler.onCommit();
                }
                if (method.getName().equals("rollback")) {
                    this.handler.onAbort();
                }
            }
            catch (Exception ex) {
                logger.warn("Error running extension for " + method.getName(), (Throwable)ex);
            }
            finally {
                try {
                    return method.invoke((Object)this.transaction, args);
                }
                catch (InvocationTargetException iex) {
                    throw iex.getTargetException();
                }
            }
        }
    }

    public static class QueryInvocationHandler
    extends Watcher<Query> {
        private InvocationListener<Query> listener;

        public QueryInvocationHandler(Query target, InvocationListener<Query> listener) {
            super(target);
            this.listener = listener;
        }

        @Override
        public Object doInvoke(Class callingClass, Object proxy, Method method, Object[] args) throws Throwable {
            return EntityManagerInvocationHandler.doInvoke(callingClass, this, this.listener, this.listener, proxy, method, args);
        }
    }
}

