/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist;

import java.util.Optional;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.persist.EntityManagerConfig;
import net.e6tech.elements.persist.EntityManagerProvider;

public class EntityManagerProviderProxy
extends EntityManagerProvider
implements Startable {
    private String delegateName;

    @Override
    public void initialize(Resources resources) {
    }

    public void start() {
        EntityManagerProvider delegate = (EntityManagerProvider)this.getResourceManager().getBean(this.delegateName);
        if (delegate == null) {
            throw new SystemException("EntityManagerProvider delegate named " + this.delegateName + " not found.");
        }
    }

    public String getDelegateName() {
        return this.delegateName;
    }

    public void setDelegateName(String delegateName) {
        this.delegateName = delegateName;
    }

    @Override
    public void onOpen(Resources resources, String alias, EntityManagerConfig config) {
        EntityManagerProvider delegate = (EntityManagerProvider)this.getResourceManager().getBean(this.delegateName);
        if (delegate != null) {
            delegate.onOpen(resources, alias, config);
        }
    }

    private Optional<EntityManagerProvider> getDelegate(Resources resources, String alias) {
        return Optional.ofNullable(resources.getMapVariable(EntityManagerProvider.class).get(alias));
    }

    @Override
    public void afterOpen(Resources resources, String alias) {
        this.getDelegate(resources, alias).ifPresent(delegate -> delegate.afterOpen(resources, alias));
    }

    @Override
    public void onCommit(Resources resources, String alias) {
        this.getDelegate(resources, alias).ifPresent(delegate -> delegate.onCommit(resources, alias));
    }

    @Override
    public void afterCommit(Resources resources, String alias) {
        this.getDelegate(resources, alias).ifPresent(delegate -> delegate.afterCommit(resources, alias));
    }

    @Override
    public void afterAbort(Resources resources, String alias) {
        this.getDelegate(resources, alias).ifPresent(delegate -> delegate.afterAbort(resources, alias));
    }

    @Override
    public void onAbort(Resources resources, String alias) {
        this.getDelegate(resources, alias).ifPresent(delegate -> delegate.onAbort(resources, alias));
    }

    @Override
    public void onClosed(Resources resources, String alias) {
        this.getDelegate(resources, alias).ifPresent(delegate -> delegate.onClosed(resources, alias));
    }

    @Override
    public void onShutdown(String alias) {
    }
}

