/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.mariadb;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.mariadb.jdbc.ClientSidePreparedStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.ServerSidePreparedStatement;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.pool.GlobalStateInfo;
import org.mariadb.jdbc.internal.util.pool.Pools;

public class MariaDbConnectionExt
extends MariaDbConnection {
    private MariaDbConnection delegate;

    public static MariaDbConnection newConnection(UrlParser urlParser, GlobalStateInfo globalInfo) throws SQLException {
        Protocol protocol = Utils.retrieveProxy((UrlParser)urlParser, (GlobalStateInfo)globalInfo);
        if (urlParser.getOptions().pool) {
            return new MariaDbConnectionExt(Pools.retrievePool((UrlParser)urlParser).getConnection(), protocol);
        }
        return new MariaDbConnectionExt(protocol);
    }

    public MariaDbConnectionExt(Protocol protocol) {
        super(protocol);
        this.delegate = new MariaDbConnection(protocol);
    }

    public MariaDbConnectionExt(MariaDbConnection delegate, Protocol protocol) {
        super(protocol);
        this.delegate = delegate;
    }

    public MariaDbConnection getDelegate() {
        return this.delegate;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return this.delegate.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public ClientSidePreparedStatement clientPrepareStatement(String sql) throws SQLException {
        return this.delegate.clientPrepareStatement(sql);
    }

    public ServerSidePreparedStatement serverPrepareStatement(String sql) throws SQLException {
        return this.delegate.serverPrepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.delegate.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegate.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.delegate.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.delegate.prepareStatement(sql, columnNames);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.delegate.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.delegate.nativeSQL(sql);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.delegate.getAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.delegate.setAutoCommit(autoCommit);
    }

    public void commit() throws SQLException {
        this.delegate.commit();
    }

    public void rollback() throws SQLException {
        this.delegate.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.delegate.rollback(savepoint);
    }

    public void close() throws SQLException {
        this.delegate.close();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public DatabaseMetaData getMetaData() {
        return this.delegate.getMetaData();
    }

    public boolean isReadOnly() throws SQLException {
        return this.delegate.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
    }

    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
    }

    public boolean isServerMariaDb() throws SQLException {
        return this.delegate.isServerMariaDb();
    }

    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        return this.delegate.versionGreaterOrEqual(major, minor, patch);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    public void reenableWarnings() {
        this.delegate.reenableWarnings();
    }

    public Map<String, Class<?>> getTypeMap() {
        return this.delegate.getTypeMap();
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.delegate.setTypeMap(map);
    }

    public int getHoldability() {
        return this.delegate.getHoldability();
    }

    public void setHoldability(int holdability) {
        this.delegate.setHoldability(holdability);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.delegate.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.delegate.setSavepoint(name);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.delegate.releaseSavepoint(savepoint);
    }

    public Clob createClob() {
        return this.delegate.createClob();
    }

    public Blob createBlob() {
        return this.delegate.createBlob();
    }

    public NClob createNClob() {
        return this.delegate.createNClob();
    }

    public SQLXML createSQLXML() throws SQLException {
        return this.delegate.createSQLXML();
    }

    public boolean isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.delegate.setClientInfo(name, value);
    }

    public Properties getClientInfo() throws SQLException {
        return this.delegate.getClientInfo();
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.delegate.setClientInfo(properties);
    }

    public String getClientInfo(String name) throws SQLException {
        return this.delegate.getClientInfo(name);
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.delegate.createArrayOf(typeName, elements);
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.delegate.createStruct(typeName, attributes);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.delegate.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) {
        return this.delegate.isWrapperFor(iface);
    }

    @Deprecated
    public String getUsername() {
        return this.delegate.getUsername();
    }

    @Deprecated
    public String getHostname() {
        return this.delegate.getHostname();
    }

    @Deprecated
    public int getPort() {
        return this.delegate.getPort();
    }

    protected boolean getPinGlobalTxToPhysicalConnection() {
        return this.getProtocol().getPinGlobalTxToPhysicalConnection();
    }

    public void setHostFailed() {
        this.delegate.setHostFailed();
    }

    public int getLowercaseTableNames() throws SQLException {
        return this.delegate.getLowercaseTableNames();
    }

    public void abort(Executor executor) throws SQLException {
        this.delegate.abort(executor);
    }

    public int getNetworkTimeout() throws SQLException {
        return this.delegate.getNetworkTimeout();
    }

    public String getSchema() {
        return this.delegate.getSchema();
    }

    public void setSchema(String arg0) {
        this.delegate.setSchema(arg0);
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.delegate.isClosed()) {
            return;
        }
        this.delegate.setNetworkTimeout(executor, milliseconds);
    }

    public long getServerThreadId() {
        if (this.delegate == null) {
            return this.getProtocol().getServerThreadId();
        }
        return this.delegate.getServerThreadId();
    }

    public boolean canUseServerTimeout() {
        return this.delegate.canUseServerTimeout();
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.delegate.setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    public void reset() throws SQLException {
        this.delegate.reset();
    }

    public boolean includeDeadLockInfo() {
        return this.delegate.includeDeadLockInfo();
    }

    public boolean includeThreadsTraces() {
        return this.delegate.includeThreadsTraces();
    }
}

