/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.datasource.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;

public class ElementsHikariDataSource
extends HikariDataSource {
    private static net.e6tech.elements.common.logging.Logger logger = net.e6tech.elements.common.logging.Logger.getLogger();
    private static Timer timer = new Timer(true);
    private List<String> connectionInitStatements = new ArrayList<String>();
    private volatile DataSource dataSource;
    private volatile boolean externalPool = false;
    private boolean resetPoolOnTimeout = true;
    private long resetPoolShutdownDelay = 3000L;
    private long resetPoolMaxFrequency = TimeUnit.MINUTES.toMillis(5L);
    private int resetPoolMaxAttempts = Integer.MAX_VALUE;
    private long resetPoolTolerance = TimeUnit.SECONDS.toMillis(30L);
    private volatile long lastReset = 0L;
    private int resetCount = 0;

    public ElementsHikariDataSource() {
    }

    public ElementsHikariDataSource(HikariConfig configuration) {
        super(configuration);
        this.externalPool = true;
    }

    public List<String> getConnectionInitStatements() {
        return this.connectionInitStatements;
    }

    public void setConnectionInitStatements(List<String> connectionInitStatements) {
        this.connectionInitStatements = connectionInitStatements;
    }

    public boolean isResetPoolOnTimeout() {
        return this.resetPoolOnTimeout;
    }

    public void setResetPoolOnTimeout(boolean resetPoolOnTimeout) {
        this.resetPoolOnTimeout = resetPoolOnTimeout;
    }

    public long getResetPoolShutdownDelay() {
        return this.resetPoolShutdownDelay;
    }

    public void setResetPoolShutdownDelay(long resetPoolShutdownDelay) {
        this.resetPoolShutdownDelay = resetPoolShutdownDelay;
    }

    public long getResetPoolMaxFrequency() {
        return this.resetPoolMaxFrequency;
    }

    public void setResetPoolMaxFrequency(long resetPoolMaxFrequency) {
        this.resetPoolMaxFrequency = resetPoolMaxFrequency;
    }

    public int getResetPoolMaxAttempts() {
        return this.resetPoolMaxAttempts;
    }

    public void setResetPoolMaxAttempts(int resetPoolMaxAttempts) {
        this.resetPoolMaxAttempts = resetPoolMaxAttempts;
    }

    public long getResetPoolTolerance() {
        return this.resetPoolTolerance;
    }

    public void setResetPoolTolerance(long resetPoolTolerance) {
        this.resetPoolTolerance = resetPoolTolerance;
    }

    public long getLastReset() {
        return this.lastReset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        DataSource ds = this.dataSource;
        if (ds == null && !this.externalPool) {
            ElementsHikariDataSource elementsHikariDataSource = this;
            synchronized (elementsHikariDataSource) {
                ds = this.dataSource;
                if (ds == null) {
                    try {
                        if (this.resetPoolOnTimeout && !this.isAllowPoolSuspension()) {
                            this.setAllowPoolSuspension(true);
                        }
                        boolean registerMBean = this.isRegisterMbeans();
                        this.setRegisterMbeans(false);
                        HikariPool pool = new HikariPool((HikariConfig)this);
                        this.setRegisterMbeans(registerMBean);
                        ds = this.dataSource = pool.getUnwrappedDataSource();
                        this.setDataSource(this.wrapDataSource(ds));
                        pool.shutdown();
                    }
                    catch (HikariPool.PoolInitializationException pie) {
                        if (pie.getCause() instanceof SQLException) {
                            throw (SQLException)pie.getCause();
                        }
                        throw pie;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        try {
            return super.getConnection();
        }
        catch (Exception e) {
            try {
                if (e instanceof SQLTransientConnectionException && this.resetPool()) {
                    try {
                        return super.getConnection();
                    }
                    catch (Exception e2) {
                        logger.error("HikariPool: failed obtaining connection after reset: {}", (Object)e2.getMessage(), (Object)e2);
                        throw e2;
                    }
                }
                throw e;
            }
            catch (Exception ex) {
                logger.error("HikariPool: failed obtaining connection: {}", (Object)ex.getMessage(), (Object)ex);
                throw e;
            }
        }
    }

    protected synchronized boolean resetPool() throws Exception {
        if (!this.resetPoolOnTimeout) {
            return false;
        }
        if (System.currentTimeMillis() - this.lastReset <= this.resetPoolTolerance) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastReset < this.resetPoolMaxFrequency) {
            logger.warn("Reset HikariPool bypassed: last reset happened " + (System.currentTimeMillis() - this.lastReset) + " milli-seconds ago.");
            return false;
        }
        if (this.resetCount >= this.resetPoolMaxAttempts) {
            logger.warn("Reset HikariPool bypassed: resetPoolMaxAttempts=" + this.resetPoolMaxAttempts);
            return false;
        }
        Field fastField = HikariDataSource.class.getDeclaredField("fastPathPool");
        Field poolField = HikariDataSource.class.getDeclaredField("pool");
        fastField.setAccessible(true);
        poolField.setAccessible(true);
        HikariPool pool = (HikariPool)fastField.get((Object)this);
        if (pool != null) {
            fastField.set((Object)this, null);
        } else {
            pool = (HikariPool)poolField.get((Object)this);
        }
        if (pool != null) {
            this.lastReset = System.currentTimeMillis();
            ++this.resetCount;
            logger.warn("Reset HikariPool due to getConnection timeout.");
            poolField.set((Object)this, null);
            if (this.isAllowPoolSuspension()) {
                pool.suspendPool();
            }
            this.unregisterPool(pool);
            final HikariPool p = pool;
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.warn("Shutting down unresponsive HikariPool: active=" + p.getActiveConnections() + ", idle=" + p.getIdleConnections() + ", awaiting=" + p.getThreadsAwaitingConnection() + ", total=" + p.getTotalConnections());
                        p.shutdown();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
            timer.schedule(task, this.resetPoolShutdownDelay);
        }
        return true;
    }

    void unregisterPool(HikariPool pool) {
        if (!this.isRegisterMbeans()) {
            return;
        }
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanConfigName = new ObjectName("com.zaxxer.hikari:type=PoolConfig (" + this.getPoolName() + ")");
            ObjectName beanPoolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + this.getPoolName() + ")");
            if (mBeanServer.isRegistered(beanConfigName)) {
                mBeanServer.unregisterMBean(beanConfigName);
                mBeanServer.unregisterMBean(beanPoolName);
            }
        }
        catch (Exception e) {
            logger.warn("{} - Failed to unregister beans.", (Object)this.getPoolName(), (Object)e);
        }
    }

    protected void initConnection(Connection connection) throws SQLException {
        if (this.connectionInitStatements.isEmpty()) {
            return;
        }
        try (Statement statement = connection.createStatement();){
            for (String sql : this.connectionInitStatements) {
                statement.addBatch(sql);
            }
            statement.executeBatch();
        }
    }

    protected DataSource wrapDataSource(DataSource ds) {
        return new WrappedDataSource(ds);
    }

    private class WrappedDataSource
    implements DataSource {
        private DataSource dataSource;

        WrappedDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection connection = this.dataSource.getConnection();
            ElementsHikariDataSource.this.initConnection(connection);
            return connection;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            Connection connection = this.dataSource.getConnection(username, password);
            ElementsHikariDataSource.this.initConnection(connection);
            return connection;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.dataSource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.dataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.dataSource.getLoginTimeout();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.dataSource.getParentLogger();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.dataSource.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.dataSource.isWrapperFor(iface);
        }
    }
}

