/*
 * Copyright 2015-2022 Futeh Kao
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.e6tech.elements.persist.mariadb;

import org.mariadb.jdbc.ClientSidePreparedStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.ServerSidePreparedStatement;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.pool.GlobalStateInfo;
import org.mariadb.jdbc.internal.util.pool.Pools;

import java.sql.*;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class MariaDbConnectionExt extends MariaDbConnection {

    private MariaDbConnection delegate;

    public static MariaDbConnection newConnection(UrlParser urlParser, GlobalStateInfo globalInfo)
            throws SQLException {
        Protocol protocol = Utils.retrieveProxy(urlParser, globalInfo);
        if (urlParser.getOptions().pool) {
            return new MariaDbConnectionExt(Pools.retrievePool(urlParser).getConnection(), protocol);
        }
        return new MariaDbConnectionExt(protocol);
    }

    public MariaDbConnectionExt(Protocol protocol) {
        super(protocol);
        delegate = new MariaDbConnection(protocol);
    }

    public MariaDbConnectionExt(MariaDbConnection delegate, Protocol protocol) {
        super(protocol);
        this.delegate = delegate;
    }

    public MariaDbConnection getDelegate() {
        return delegate;
    }

    @Override
    public Statement createStatement(final int resultSetType, final int resultSetConcurrency) {
        return delegate.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) {
        return delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public ClientSidePreparedStatement clientPrepareStatement(final String sql) throws SQLException {
        return delegate.clientPrepareStatement(sql);
    }

    @Override
    public ServerSidePreparedStatement serverPrepareStatement(final String sql) throws SQLException {
        return delegate.serverPrepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql) throws SQLException {
        return delegate.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(
            final String sql, final int resultSetType, final int resultSetConcurrency)
            throws SQLException {
        return delegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(
            final String sql,
            final int resultSetType,
            final int resultSetConcurrency,
            final int resultSetHoldability)
            throws SQLException {
        return delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int autoGeneratedKeys)
            throws SQLException {
        return delegate.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int[] columnIndexes)
            throws SQLException {
        return delegate.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final String[] columnNames)
            throws SQLException {
        return delegate.prepareStatement(sql, columnNames);
    }

    @Override
    public CallableStatement prepareCall(final String sql) throws SQLException {
        return delegate.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(
            final String sql, final int resultSetType, final int resultSetConcurrency)
            throws SQLException {
        return delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(
            final String sql,
            final int resultSetType,
            final int resultSetConcurrency,
            final int resultSetHoldability)
            throws SQLException {
        return delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public String nativeSQL(final String sql) throws SQLException {
        return delegate.nativeSQL(sql);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return delegate.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        delegate.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        delegate.commit();
    }

    @Override
    public void rollback() throws SQLException {
        delegate.rollback();
    }

    @Override
    public void rollback(final Savepoint savepoint) throws SQLException {
        delegate.rollback(savepoint);
    }

    @Override
    public void close() throws SQLException {
        delegate.close();
    }

    @Override
    public boolean isClosed() {
        return delegate.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return delegate.getMetaData();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return delegate.isReadOnly();
    }

    @Override
    public void setReadOnly(final boolean readOnly) throws SQLException {
        delegate.setReadOnly(readOnly);
    }

    @Override
    public String getCatalog() throws SQLException {
        return delegate.getCatalog();
    }

    @Override
    public void setCatalog(final String catalog) throws SQLException {
        delegate.setCatalog(catalog);
    }

    @Override
    public boolean isServerMariaDb() throws SQLException {
        return delegate.isServerMariaDb();
    }

    @Override
    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        return delegate.versionGreaterOrEqual(major, minor, patch);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return delegate.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(final int level) throws SQLException {
        delegate.setTransactionIsolation(level);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        delegate.clearWarnings();
    }

    @Override
    public void reenableWarnings() {
        delegate.reenableWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return delegate.getTypeMap();
    }

    @Override
    public void setTypeMap(final Map<String, Class<?>> map) throws SQLException {
        delegate.setTypeMap(map);
    }

    @Override
    public int getHoldability() {
        return delegate.getHoldability();
    }

    @Override
    public void setHoldability(final int holdability) {
        delegate.setHoldability(holdability);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(final String name) throws SQLException {
        return delegate.setSavepoint(name);
    }

    @Override
    public void releaseSavepoint(final Savepoint savepoint) throws SQLException {
        delegate.releaseSavepoint(savepoint);
    }

    @Override
    public Clob createClob() {
        return delegate.createClob();
    }

    @Override
    public Blob createBlob() {
        return delegate.createBlob();
    }

    @Override
    public NClob createNClob() {
        return delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return delegate.createSQLXML();
    }

    @Override
    public boolean isValid(final int timeout) throws SQLException {
        return delegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(final String name, final String value) throws SQLClientInfoException {
        delegate.setClientInfo(name, value);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return delegate.getClientInfo();
    }

    @Override
    public void setClientInfo(final Properties properties) throws SQLClientInfoException {
        delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(final String name) throws SQLException {
        return delegate.getClientInfo(name);
    }

    @Override
    public Array createArrayOf(final String typeName, final Object[] elements) throws SQLException {
        return delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(final String typeName, final Object[] attributes) throws SQLException {
        return delegate.createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(final Class<T> iface) throws SQLException {
        return delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(final Class<?> iface) {
        return delegate.isWrapperFor(iface);
    }

    @Deprecated
    @Override
    public String getUsername() {
        return delegate.getUsername();
    }

    @Override
    @Deprecated
    public String getHostname() {
        return delegate.getHostname();
    }

    @Override
    @Deprecated
    public int getPort() {
        return delegate.getPort();
    }

    protected boolean getPinGlobalTxToPhysicalConnection() {
        return getProtocol().getPinGlobalTxToPhysicalConnection();
    }

    @Override
    public void setHostFailed() {
        delegate.setHostFailed();
    }

    @Override
    public int getLowercaseTableNames() throws SQLException {
        return delegate.getLowercaseTableNames();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        delegate.abort(executor);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return delegate.getNetworkTimeout();
    }

    @Override
    public String getSchema() {
        return delegate.getSchema();
    }

    @Override
    public void setSchema(String arg0) {
        delegate.setSchema(arg0);
    }

    @Override
    public void setNetworkTimeout(Executor executor, final int milliseconds) throws SQLException {
        if (delegate.isClosed()) {
            return;
        }
        delegate.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public long getServerThreadId() {
        if (delegate == null)
            return getProtocol().getServerThreadId();
        return delegate.getServerThreadId();
    }

    @Override
    public boolean canUseServerTimeout() {
        return delegate.canUseServerTimeout();
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        delegate.setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    @Override
    public void reset() throws SQLException {
       delegate.reset();
    }

    public boolean includeDeadLockInfo() {
        return delegate.includeDeadLockInfo();
    }

    public boolean includeThreadsTraces() {
        return delegate.includeThreadsTraces();
    }

}
