/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.criteria;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.persist.criteria.Comparison;
import net.e6tech.elements.persist.criteria.Handler;
import net.e6tech.elements.persist.criteria.Where;

public class Statement<T> {
    Where<T> where;
    From<T, T> from;

    public Statement(Where where, From<T, T> from) {
        this.where = where;
        this.from = from;
    }

    public CriteriaBuilder getBuilder() {
        return this.where.getBuilder();
    }

    public CriteriaQuery<T> getQuery() {
        return this.where.getQuery();
    }

    public T getTemplate() {
        return this.where.getTemplate();
    }

    public From<T, T> getFrom() {
        return this.from;
    }

    public void or(Runnable runnable) {
        Where<T> wh = new Where<T>(this.where, this.where.getPath());
        wh.setTemplate(this.where.getTemplate());
        Interceptor.setInterceptorHandler(wh.getTemplate(), wh);
        wh.predicates = new ArrayList<Predicate>();
        runnable.run();
        Interceptor.setInterceptorHandler(wh.getTemplate(), this.where);
        List<Predicate> predicates = wh.getPredicates();
        if (!predicates.isEmpty()) {
            CriteriaBuilder builder = this.where.getBuilder();
            Predicate predicate = builder.or(predicates.toArray(new Predicate[predicates.size()]));
            this.where.getPredicates().add(predicate);
        }
    }

    public T equalTo() {
        return this.compare(this.where.getTemplate(), Comparison.equal);
    }

    public T notEqual() {
        return this.compare(this.where.getTemplate(), Comparison.not_equal);
    }

    public T like() {
        return this.compare(this.where.getTemplate(), Comparison.like);
    }

    public T in(List list) {
        Class entityClass = Interceptor.getTargetClass(this.where.getTemplate());
        return (T)this.applyGetter(entityClass, path -> {
            Predicate predicate = Comparison.in.compare(this.getBuilder(), (Expression)path, list);
            this.where.getPredicates().add(predicate);
        });
    }

    public T lessThan() {
        return this.compare(this.where.getTemplate(), Comparison.less_than);
    }

    public T lessThanOrEqualTo() {
        return this.compare(this.where.getTemplate(), Comparison.less_than_or_equal);
    }

    public T greaterThan() {
        return this.compare(this.where.getTemplate(), Comparison.greater_than);
    }

    public T greaterThanOrEqualTo() {
        return this.compare(this.where.getTemplate(), Comparison.greater_than_or_equal);
    }

    protected T compare(T template, Comparison comparison) {
        Class entityClass = Interceptor.getTargetClass(template);
        return (T)this.applySetter(entityClass, (path, args) -> {
            Predicate predicate = comparison.compare(this.getBuilder(), (Expression)path, args[0]);
            this.where.getPredicates().add(predicate);
        });
    }

    protected <R> R applySetter(Class<R> entityClass, BiConsumer<Path, Object[]> consumer) {
        return (R)Handler.interceptor.newInstance(entityClass, this.setter(consumer));
    }

    protected <R> R applyGetter(Class<R> entityClass, Consumer<Path> consumer) {
        return (R)Handler.interceptor.newInstance(entityClass, this.getter(consumer));
    }

    protected InterceptorHandler getter(Consumer<Path> consumer) {
        return frame -> {
            PropertyDescriptor desc = Reflection.propertyDescriptor((Method)frame.getMethod());
            String property = desc.getName();
            if (!frame.getMethod().equals(desc.getReadMethod())) {
                throw new UnsupportedOperationException("Only accepts getter");
            }
            consumer.accept(this.where.getPath().get(property));
            return Primitives.defaultValue(desc.getPropertyType());
        };
    }

    private InterceptorHandler setter(BiConsumer<Path, Object[]> consumer) {
        return frame -> {
            PropertyDescriptor desc = Reflection.propertyDescriptor((Method)frame.getMethod());
            String property = desc.getName();
            if (frame.getMethod().equals(desc.getReadMethod())) {
                throw new UnsupportedOperationException("Only accepts setter");
            }
            consumer.accept(this.where.getPath().get(property), frame.getArguments());
            return null;
        };
    }
}

