/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist;

import java.util.concurrent.ExecutorService;
import javax.persistence.EntityManager;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.persist.EntityManagerProvider;

public class EntityManagerMonitor {
    private static final Logger logger = Logger.getLogger();
    private EntityManagerProvider provider;
    private Resources resources;
    private EntityManager entityManager;
    private long expiration;
    private Throwable throwable;
    private ExecutorService threadPool;
    private Thread originatingThread;
    private volatile boolean interrupted = false;
    private String alias;

    EntityManagerMonitor(String alias, ExecutorService threadPool, EntityManagerProvider provider, Resources resources, EntityManager entityManager, long expiration, Throwable throwable) {
        this.alias = alias;
        this.provider = provider;
        this.resources = resources;
        this.entityManager = entityManager;
        this.expiration = expiration;
        this.throwable = throwable;
        this.threadPool = threadPool;
        this.originatingThread = Thread.currentThread();
    }

    public long getExpiration() {
        return this.expiration;
    }

    public EntityManagerMonitor expire(long exp) {
        this.expiration = System.currentTimeMillis() + exp;
        return this;
    }

    public void addExpiration(long extension) {
        this.expiration += extension;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    void rollback() {
        this.threadPool.execute(() -> {
            try {
                this.interrupt();
                if (this.entityManager.isOpen()) {
                    this.provider.cancelQuery(this.resources, this.alias);
                }
            }
            catch (Throwable ex) {
                logger.warn("Unexpected exception in EntityManagerMonitor cancel query", this.throwable);
            }
            try {
                EntityManager ex = this.entityManager;
                synchronized (ex) {
                    if (this.entityManager.isOpen()) {
                        this.provider.onAbort(this.resources, this.alias);
                        logger.warn("EntityManagerProvider timeout", this.throwable);
                    }
                }
            }
            catch (Throwable ex) {
                logger.warn("Unexpected exception in EntityManagerMonitor during rollback", this.throwable);
            }
        });
    }

    private synchronized void interrupt() {
        if (!this.interrupted) {
            this.originatingThread.interrupt();
            this.interrupted = true;
        }
    }

    synchronized void close() {
        if (this.interrupted) {
            Thread.interrupted();
        }
    }
}

