/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.criteria;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.datastructure.Pair;
import net.e6tech.elements.persist.criteria.Comparison;
import net.e6tech.elements.persist.criteria.Handler;

public class Where<T>
extends Handler {
    Where parent;
    T template;
    Comparison comparison = Comparison.equal;
    List<Predicate> predicates = new ArrayList<Predicate>();
    List<Order> orderByList = new ArrayList<Order>();
    Map<Pair, Function> converters = new HashMap<Pair, Function>();

    public Where(Where parent, Path path) {
        this(parent.getEntityManager(), parent.getBuilder(), parent.getQuery(), path);
        this.parent = parent;
        this.predicates = parent.predicates;
        this.comparison = parent.getComparison();
        this.orderByList = parent.getOrderByList();
        this.converters = parent.getConverters();
    }

    public Where(EntityManager entityManager, CriteriaBuilder builder, CriteriaQuery query, Path path) {
        super(entityManager, builder, query, path);
        this.template = Handler.interceptor.newInstance(path.getJavaType(), (InterceptorHandler)this);
    }

    public Map<Pair, Function> getConverters() {
        return this.converters;
    }

    public void setConverters(Map<Pair, Function> converters) {
        this.converters = converters;
    }

    public <X, R> void addConverter(Class<X> fromType, Class<R> toType, Function<X, R> converter) {
        Class toPrimitive;
        this.converters.put(new Pair(fromType, toType), converter);
        Class fromPrimitive = Primitives.getPrimitiveType(fromType);
        if (fromPrimitive != null) {
            this.converters.put(new Pair((Object)fromPrimitive, toType), converter);
        }
        if ((toPrimitive = Primitives.getPrimitiveType(toType)) != null) {
            this.converters.put(new Pair(fromType, (Object)toPrimitive), converter);
        }
        if (fromPrimitive != null && toPrimitive != null) {
            this.converters.put(new Pair((Object)fromPrimitive, (Object)toPrimitive), converter);
        }
    }

    public <X, R> void removeConverter(Class<X> fromType, Class<R> toType) {
        Class toPrimitive;
        this.converters.remove(new Pair(fromType, toType));
        Class fromPrimitive = Primitives.getPrimitiveType(fromType);
        if (fromPrimitive != null) {
            this.converters.remove(new Pair((Object)fromPrimitive, toType));
        }
        if ((toPrimitive = Primitives.getPrimitiveType(toType)) != null) {
            this.converters.remove(new Pair(fromType, (Object)toPrimitive));
        }
        if (fromPrimitive != null && toPrimitive != null) {
            this.converters.remove(new Pair((Object)fromPrimitive, (Object)toPrimitive));
        }
    }

    public T getTemplate() {
        return this.template;
    }

    public void setTemplate(T template) {
        this.template = template;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(List<Predicate> predicates) {
        this.predicates = predicates;
    }

    public List<Order> getOrderByList() {
        return this.orderByList;
    }

    public void setOrderByList(List<Order> orderByList) {
        this.orderByList = orderByList;
    }

    @Override
    public void onQuery() {
        if (!this.getPredicates().isEmpty()) {
            this.getQuery().where(this.getPredicates().toArray(new Predicate[this.getPredicates().size()]));
        }
        if (!this.orderByList.isEmpty()) {
            this.getQuery().orderBy(this.orderByList);
        }
    }

    public Object invoke(CallFrame frame) {
        Function function;
        PropertyDescriptor desc = Reflection.propertyDescriptor((Method)frame.getMethod());
        String property = desc.getName();
        CriteriaBuilder builder = this.getBuilder();
        if (frame.getMethod().equals(desc.getReadMethod())) {
            Class<?> cls = frame.getMethod().getReturnType();
            if (!Modifier.isFinal(cls.getModifiers())) {
                Where<T> where = new Where<T>(this, this.getPath().get(property));
                return where.getTemplate();
            }
            if (cls.isPrimitive()) {
                return Primitives.defaultValue(cls);
            }
            return Primitives.defaultValue(desc.getPropertyType());
        }
        Path current = this.getPath().get(property);
        Class javaType = current.getJavaType();
        Object value = frame.getArguments()[0];
        if (value != null && (function = this.converters.get(new Pair(value.getClass(), (Object)javaType))) != null) {
            value = function.apply(value);
        }
        this.predicates.add(this.comparison.compare(builder, (Expression)current, value));
        return null;
    }
}

