/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.metamodel.Metamodel;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.reflection.Annotator;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.persist.EntityManagerConfig;
import net.e6tech.elements.persist.EntityManagerInvocationHandler;
import net.e6tech.elements.persist.EntityManagerMonitor;
import net.e6tech.elements.persist.EvictCollectionRegion;
import net.e6tech.elements.persist.EvictEntity;
import net.e6tech.elements.persist.EvictEntityRegion;

public abstract class EntityManagerProvider
implements ResourceProvider,
Initializable {
    private static final String DEFAULT_NAME = "default";
    private static final String[] DEFAULT_PROVIDER_NAMES = new String[]{"default"};
    private static Logger logger = Logger.getLogger();
    private ExecutorService threadPool;
    private NotificationCenter notificationCenter;
    protected EntityManagerFactory emf;
    private String persistenceUnitName;
    private Map persistenceProperties;
    private Broadcast broadcast;
    private long transactionTimeout = 0L;
    private boolean monitorTransaction = true;
    private long longTransaction = 200L;
    private boolean firstQuery = true;
    private AtomicInteger ignoreInitialLongTransactions = new AtomicInteger(1);
    private BlockingQueue<EntityManagerMonitor> monitorQueue = new LinkedBlockingQueue<EntityManagerMonitor>();
    private final List<EntityManagerMonitor> entityManagerMonitors = new ArrayList<EntityManagerMonitor>();
    private volatile boolean shutdown = false;
    private String providerName = "default";

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    @Inject(optional=true)
    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public NotificationCenter getNotificationCenter() {
        return this.notificationCenter;
    }

    @Inject(optional=true)
    public void setNotificationCenter(NotificationCenter center) {
        this.notificationCenter = center;
    }

    public Broadcast getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(Broadcast broadcast) {
        this.broadcast = broadcast;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public Map getPersistenceProperties() {
        return this.persistenceProperties;
    }

    public void setPersistenceProperties(Map persistenceProperties) {
        this.persistenceProperties = persistenceProperties;
    }

    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public long getLongTransaction() {
        return this.longTransaction;
    }

    public void setLongTransaction(long longTransaction) {
        this.longTransaction = longTransaction;
    }

    public boolean isMonitorTransaction() {
        return this.monitorTransaction;
    }

    public void setMonitorTransaction(boolean monitorTransaction) {
        this.monitorTransaction = monitorTransaction;
    }

    public int getIgnoreInitialLongTransactions() {
        if (this.ignoreInitialLongTransactions == null) {
            return 0;
        }
        return this.ignoreInitialLongTransactions.get();
    }

    public void setIgnoreInitialLongTransactions(int n) {
        this.ignoreInitialLongTransactions = new AtomicInteger(n);
    }

    public List<EntityManagerMonitor> getEntityManagerMonitors() {
        return this.entityManagerMonitors;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    protected void evictCollectionRegion(EvictCollectionRegion notification) {
    }

    protected void evictEntityRegion(EvictEntityRegion region) {
    }

    protected void evictEntity(EvictEntity ref) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Resources resources) {
        this.startMonitoring();
        this.emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, (Map)this.persistenceProperties);
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            Metamodel meta = this.emf.getMetamodel();
            meta.getManagedTypes().forEach(type -> {
                type.getDeclaredAttributes();
                type.getPersistenceType();
            });
        }
        NotificationCenter center = resources.getNotificationCenter();
        center.subscribe(EvictCollectionRegion.class, notice -> this.evictCollectionRegion((EvictCollectionRegion)((Object)notice.getUserObject())));
        center.subscribe(EvictEntityRegion.class, notice -> this.evictEntityRegion((EvictEntityRegion)((Object)notice.getUserObject())));
        center.subscribe(EvictEntity.class, notice -> this.evictEntity((EvictEntity)((Object)notice.getUserObject())));
    }

    private String[] providerNames(Resources resources) {
        Optional config = resources.configurator().annotation(EntityManagerConfig.class);
        String[] names = config.map(EntityManagerConfig::names).orElse(DEFAULT_PROVIDER_NAMES);
        if (this.providerName.length() == 0) {
            names = DEFAULT_PROVIDER_NAMES;
        }
        return names;
    }

    private void shouldOpen(Resources resources) {
        Map map;
        Optional config = resources.configurator().annotation(EntityManagerConfig.class);
        if (config.isPresent() && ((EntityManagerConfig)config.get()).disable()) {
            throw new NotAvailableException();
        }
        String[] names = this.providerNames(resources);
        if (names.length == 0) {
            return;
        }
        boolean found = false;
        for (String n : names) {
            if (!n.equals(this.getProviderName())) continue;
            found = true;
            break;
        }
        if ((map = resources.getMapVariable(EntityManager.class)).get(this.getProviderName()) != null) {
            throw new IllegalStateException("There is already an EntityManagerProvider named " + this.getProviderName() + " configured!");
        }
        if (!found) {
            throw new NotAvailableException();
        }
    }

    private EntityManagerConfig configuration(Resources resources) {
        Optional config = resources.configurator().annotation(EntityManagerConfig.class);
        long timeout = config.map(EntityManagerConfig::timeout).orElse(this.transactionTimeout);
        if (timeout == 0L) {
            timeout = this.transactionTimeout;
        }
        long timeoutExt = config.map(EntityManagerConfig::timeoutExtension).orElse(0L);
        timeout += timeoutExt;
        boolean monitor = config.map(EntityManagerConfig::monitor).orElse(this.monitorTransaction);
        long longQuery = config.map(EntityManagerConfig::longTransaction).orElse(this.longTransaction);
        if (longQuery == 0L) {
            longQuery = this.longTransaction;
        }
        if (this.firstQuery) {
            this.firstQuery = false;
            if (longQuery < 1000L) {
                longQuery = 1000L;
            }
        }
        long longQueryFinal = longQuery;
        long timeoutFinal = timeout;
        String[] names = this.providerNames(resources);
        EntityManagerConfig result = (EntityManagerConfig)Annotator.create(EntityManagerConfig.class, (v, a) -> v.set(a::names, (Object)names).set(a::disable, (Object)config.map(c -> c.disable()).orElse(false)).set(a::timeout, (Object)timeoutFinal).set(a::longTransaction, (Object)longQueryFinal).set(a::monitor, (Object)monitor).set(a::timeoutExtension, (Object)timeoutExt));
        resources.getMapVariable(EntityManagerConfig.class).put(this.getProviderName(), result);
        return result;
    }

    public void onOpen(Resources resources) {
        this.shouldOpen(resources);
        EntityManagerConfig config = this.configuration(resources);
        EntityManager em = this.emf.createEntityManager();
        if (config.monitor()) {
            EntityManagerMonitor entityManagerMonitor = new EntityManagerMonitor(this.threadPool, this, resources, em, System.currentTimeMillis() + config.timeout(), new Throwable());
            this.monitor(entityManagerMonitor);
            resources.getMapVariable(EntityManagerMonitor.class).put(this.getProviderName(), entityManagerMonitor);
        }
        EntityManagerInvocationHandler emHandler = new EntityManagerInvocationHandler(resources, em);
        emHandler.setLongTransaction(config.longTransaction());
        emHandler.setIgnoreInitialLongTransactions(this.ignoreInitialLongTransactions);
        EntityManager proxy = (EntityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)emHandler);
        if (!resources.hasInstance(EntityManager.class)) {
            resources.bind(EntityManager.class, (Object)proxy);
        } else if (this.getProviderName().equals(DEFAULT_NAME)) {
            resources.rebind(EntityManager.class, (Object)proxy);
        }
        resources.getMapVariable(EntityManager.class).put(this.getProviderName(), proxy);
        em.getTransaction().begin();
    }

    private void monitor(EntityManagerMonitor monitor) {
        if (!this.shutdown) {
            this.monitorQueue.offer(monitor);
        }
    }

    private void startMonitoring() {
        if (this.threadPool == null) {
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            this.threadPool = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(group, runnable, "EntityManagerProvider");
                thread.setName("EntityManagerProvider-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            });
        }
        this.threadPool.execute(() -> {
            while (!this.shutdown) {
                try {
                    long expiration = 0L;
                    this.monitorQueue.drainTo(this.entityManagerMonitors);
                    Iterator<EntityManagerMonitor> iterator = this.entityManagerMonitors.iterator();
                    while (iterator.hasNext()) {
                        EntityManagerMonitor m = iterator.next();
                        if (!m.getEntityManager().isOpen()) {
                            iterator.remove();
                            continue;
                        }
                        if (m.getExpiration() < System.currentTimeMillis()) {
                            iterator.remove();
                            m.rollback();
                            continue;
                        }
                        if (expiration != 0L && m.getExpiration() >= expiration) continue;
                        expiration = m.getExpiration();
                    }
                    long sleep = 0L;
                    if (expiration > 0L && (sleep = expiration - System.currentTimeMillis()) < 0L) {
                        sleep = !this.entityManagerMonitors.isEmpty() ? 1L : 0L;
                    }
                    EntityManagerMonitor newMonitor = null;
                    try {
                        newMonitor = sleep == 0L ? this.monitorQueue.take() : this.monitorQueue.poll(sleep, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (newMonitor == null) continue;
                    this.entityManagerMonitors.add(newMonitor);
                }
                catch (Throwable ex) {
                    logger.error("Unexpected exception in EntityManagerProvider during monitoring", ex);
                }
            }
        });
    }

    public void onCommit(Resources resources) {
        try {
            EntityManager em = (EntityManager)resources.getMapVariable(EntityManager.class).get(this.getProviderName());
            em.getTransaction().commit();
            em.clear();
            em.close();
        }
        catch (InstanceNotFoundException ex) {
            Logger.suppress((Throwable)ex);
        }
        finally {
            this.cleanup(resources);
        }
    }

    public void afterCommit(Resources resources) {
    }

    public void onAbort(Resources resources) {
        try {
            EntityManager em = (EntityManager)resources.getMapVariable(EntityManager.class).get(this.getProviderName());
            em.getTransaction().rollback();
            em.clear();
            em.close();
        }
        catch (Exception th) {
            Logger.suppress((Throwable)th);
        }
        finally {
            this.cleanup(resources);
        }
    }

    protected void cleanup(Resources resources) {
    }

    public void onClosed(Resources resources) {
        EntityManagerMonitor m = (EntityManagerMonitor)resources.getMapVariable(EntityManagerMonitor.class).get(this.getProviderName());
        if (m != null) {
            m.close();
        }
    }

    public void onShutdown() {
        if (this.emf.isOpen()) {
            this.emf.close();
        }
        this.shutdown = true;
    }

    public void cancelQuery(Resources resources) {
    }
}

