/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.persist.EntityManagerConfig;
import net.e6tech.elements.persist.EntityManagerInfo;
import net.e6tech.elements.persist.EntityManagerProvider;
import net.e6tech.elements.persist.InvocationListener;
import net.e6tech.elements.persist.Watcher;

public class EntityManagerInvocationHandler
extends Watcher<EntityManager>
implements EntityManagerInfo {
    private static Set<Method> infoMethods = new HashSet<Method>();
    private Resources resources;
    private String alias;
    private EntityManagerProvider provider;
    private EntityManagerConfig config;
    private InvocationListener<EntityManager> entityManagerListener;
    private InvocationListener<Query> queryListener;

    public EntityManagerInvocationHandler(Resources resources, EntityManager em, String alias, EntityManagerProvider provider, EntityManagerConfig config, InvocationListener<EntityManager> entityManagerListener, InvocationListener<Query> queryListener) {
        super(em);
        this.resources = resources;
        this.alias = alias;
        this.provider = provider;
        this.config = config;
        this.entityManagerListener = entityManagerListener;
        this.queryListener = queryListener;
    }

    private static Object doInvoke(Class callingClass, Watcher watcher, InvocationListener listener, InvocationListener<Query> queryListener, Object proxy, Method method, Object[] args) throws Throwable {
        Object ret;
        long start;
        block10: {
            start = System.currentTimeMillis();
            ret = null;
            try {
                if (listener != null) {
                    listener.beforeInvocation(callingClass, proxy, method, args);
                }
                ret = method.invoke(watcher.getTarget(), args);
                if (listener == null) break block10;
                listener.afterInvocation(callingClass, proxy, method, args, ret);
            }
            catch (InvocationTargetException ex) {
                try {
                    Logger.suppress((Throwable)ex);
                    if (listener != null) {
                        listener.onException(callingClass, proxy, method, args, ex.getTargetException());
                    }
                    throw ex.getCause();
                }
                catch (Throwable throwable) {
                    if (logger.isDebugEnabled() && watcher.isMonitorTransaction()) {
                        long duration = System.currentTimeMillis() - start;
                        Class<?> returnType = method.getReturnType();
                        if (ret != null && Query.class.isAssignableFrom(returnType)) {
                            QueryInvocationHandler handler = new QueryInvocationHandler((Query)ret, queryListener);
                            handler.listener = queryListener;
                            handler.setLongTransaction(watcher.getLongTransaction());
                            handler.setIgnoreInitialLongTransactions(watcher.getIgnoreInitialLongTransactions());
                            ret = returnType.isInterface() ? Proxy.newProxyInstance(watcher.getClass().getClassLoader(), new Class[]{returnType}, (InvocationHandler)handler) : Proxy.newProxyInstance(watcher.getClass().getClassLoader(), returnType.getInterfaces(), (InvocationHandler)handler);
                        }
                        watcher.log(method, args, duration);
                    }
                    throw throwable;
                }
            }
        }
        if (logger.isDebugEnabled() && watcher.isMonitorTransaction()) {
            long duration = System.currentTimeMillis() - start;
            Class<?> returnType = method.getReturnType();
            if (ret != null && Query.class.isAssignableFrom(returnType)) {
                QueryInvocationHandler handler = new QueryInvocationHandler((Query)ret, queryListener);
                handler.listener = queryListener;
                handler.setLongTransaction(watcher.getLongTransaction());
                handler.setIgnoreInitialLongTransactions(watcher.getIgnoreInitialLongTransactions());
                ret = returnType.isInterface() ? Proxy.newProxyInstance(watcher.getClass().getClassLoader(), new Class[]{returnType}, (InvocationHandler)handler) : Proxy.newProxyInstance(watcher.getClass().getClassLoader(), returnType.getInterfaces(), (InvocationHandler)handler);
            }
            watcher.log(method, args, duration);
        }
        return ret;
    }

    @Override
    public Object doInvoke(Class callingClass, Object proxy, Method method, Object[] args) throws Throwable {
        if (infoMethods.contains(method)) {
            return method.invoke((Object)this, args);
        }
        return EntityManagerInvocationHandler.doInvoke(callingClass, this, this.entityManagerListener, this.queryListener, proxy, method, args);
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public EntityManagerProvider getProvider() {
        return this.provider;
    }

    @Override
    public EntityManagerConfig getConfig() {
        return this.config;
    }

    static {
        for (Method method : EntityManagerInfo.class.getDeclaredMethods()) {
            infoMethods.add(method);
        }
        for (Method method : EntityManagerInvocationHandler.class.getDeclaredMethods()) {
            infoMethods.add(method);
        }
    }

    public static class QueryInvocationHandler
    extends Watcher<Query> {
        private InvocationListener<Query> listener;

        public QueryInvocationHandler(Query target, InvocationListener<Query> listener) {
            super(target);
            this.listener = listener;
        }

        @Override
        public Object doInvoke(Class callingClass, Object proxy, Method method, Object[] args) throws Throwable {
            return EntityManagerInvocationHandler.doInvoke(callingClass, this, this.listener, this.listener, proxy, method, args);
        }
    }
}

