/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist;

import javax.persistence.EntityManager;
import net.e6tech.elements.common.logging.Logger;

public class EntityManagerMonitor {
    private static final Logger logger = Logger.getLogger();
    private EntityManager entityManager;
    private long expiration;
    private Throwable throwable;

    EntityManagerMonitor(EntityManager entityManager, long expiration, Throwable throwable) {
        this.entityManager = entityManager;
        this.expiration = expiration;
        this.throwable = throwable;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void addExpiration(long extension) {
        this.expiration += extension;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    void rollback() {
        if (this.entityManager.isOpen()) {
            this.entityManager.getTransaction().setRollbackOnly();
            this.entityManager.close();
            logger.warn("EntityManagerProvider timeout", this.throwable);
        }
    }
}

