/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.datasource.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ElementsHikariDataSource
extends HikariDataSource {
    private List<String> connectionInitStatements = new ArrayList<String>();
    private volatile DataSource dataSource;
    private volatile boolean externalPool = false;

    public ElementsHikariDataSource() {
    }

    public ElementsHikariDataSource(HikariConfig configuration) {
        super(configuration);
        this.externalPool = true;
    }

    public List<String> getConnectionInitStatements() {
        return this.connectionInitStatements;
    }

    public void setConnectionInitStatements(List<String> connectionInitStatements) {
        this.connectionInitStatements = connectionInitStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        DataSource ds = this.dataSource;
        if (ds == null && !this.externalPool) {
            ElementsHikariDataSource elementsHikariDataSource = this;
            synchronized (elementsHikariDataSource) {
                ds = this.dataSource;
                if (ds == null) {
                    try {
                        boolean registerMBean = this.isRegisterMbeans();
                        this.setRegisterMbeans(false);
                        HikariPool pool = new HikariPool((HikariConfig)this);
                        this.setRegisterMbeans(registerMBean);
                        ds = this.dataSource = pool.getUnwrappedDataSource();
                        this.setDataSource(this.wrapDataSource(ds));
                        pool.shutdown();
                    }
                    catch (HikariPool.PoolInitializationException pie) {
                        if (pie.getCause() instanceof SQLException) {
                            throw (SQLException)pie.getCause();
                        }
                        throw pie;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        return super.getConnection();
    }

    protected void initConnection(Connection connection) throws SQLException {
        if (this.connectionInitStatements.size() == 0) {
            return;
        }
        try (Statement statement = connection.createStatement();){
            for (String sql : this.connectionInitStatements) {
                statement.addBatch(sql);
            }
            statement.executeBatch();
        }
    }

    protected DataSource wrapDataSource(DataSource ds) {
        return new WrappedDataSource(ds);
    }

    private class WrappedDataSource
    implements DataSource {
        private DataSource dataSource;

        WrappedDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection connection = this.dataSource.getConnection();
            ElementsHikariDataSource.this.initConnection(connection);
            return connection;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            Connection connection = this.dataSource.getConnection(username, password);
            ElementsHikariDataSource.this.initConnection(connection);
            return connection;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.dataSource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.dataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.dataSource.getLoginTimeout();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.dataSource.getParentLogger();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.dataSource.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.dataSource.isWrapperFor(iface);
        }
    }
}

