/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.datasource.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ElementsHikariDataSource
extends HikariDataSource {
    private List<String> connectionInitStatements = new ArrayList<String>();

    public ElementsHikariDataSource() {
    }

    public ElementsHikariDataSource(HikariConfig configuration) {
        super(configuration);
    }

    public List<String> getConnectionInitStatements() {
        return this.connectionInitStatements;
    }

    public void setConnectionInitStatements(List<String> connectionInitStatements) {
        this.connectionInitStatements = connectionInitStatements;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        this.initConnection(connection);
        return connection;
    }

    protected void initConnection(Connection connection) throws SQLException {
        if (this.connectionInitStatements.size() == 0) {
            return;
        }
        try (Statement statement = connection.createStatement();){
            for (String sql : this.connectionInitStatements) {
                statement.addBatch(sql);
            }
            statement.executeBatch();
        }
    }
}

