/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.criteria;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.persist.criteria.Handler;
import net.e6tech.elements.persist.criteria.OrderBy;
import net.e6tech.elements.persist.criteria.Statement;
import net.e6tech.elements.persist.criteria.Where;

public class Select<T>
extends Statement<T> {
    Select parent;
    int maxResults = -1;
    List<Selection<?>> selections = new ArrayList();

    public static <T> Select<T> create(EntityManager entityManager, Class<T> cls) {
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root root = query.from(cls);
        Where where = new Where(entityManager, builder, query, (Path)root);
        return new Select<T>(where, root);
    }

    public Select(Where where, Root<T> root) {
        super(where, root);
    }

    protected Select(Select parent, Where where, From<?, T> root) {
        super(where, root);
        this.parent = parent;
        this.selections = parent.selections;
    }

    public Select<T> where(Consumer<T> consumer) {
        consumer.accept(this.where.getTemplate());
        this.where.onQuery();
        return this;
    }

    public Select<T> where(BiConsumer<Select<T>, T> consumer) {
        consumer.accept(this, (Select)this.where.getTemplate());
        this.where.onQuery();
        return this;
    }

    public <R> R getSingleResult() {
        this.where.onQuery();
        if (this.selections.size() == 1) {
            this.getQuery().select(this.selections.get(0));
        } else if (this.selections.size() > 0) {
            this.getQuery().multiselect(this.selections);
        } else {
            this.getQuery().select(this.getFrom());
        }
        TypedQuery query = this.where.getEntityManager().createQuery(this.getQuery());
        if (this.maxResults >= 0) {
            query.setMaxResults(this.maxResults);
        }
        return (R)query.getSingleResult();
    }

    public <R> List<R> getResultList() {
        this.where.onQuery();
        if (this.selections.size() == 1) {
            this.getQuery().select(this.selections.get(0));
        } else if (this.selections.size() > 0) {
            this.getQuery().multiselect(this.selections.toArray(new Selection[this.selections.size()]));
        } else {
            this.getQuery().select(this.getFrom());
        }
        TypedQuery query = this.where.getEntityManager().createQuery(this.getQuery());
        if (this.maxResults >= 0) {
            query.setMaxResults(this.maxResults);
        }
        return query.getResultList();
    }

    public Select<T> selectEntity() {
        this.selections.add((Selection<?>)this.getFrom());
        return this;
    }

    public <R> Select<T> select(Expression<R> expression) {
        this.selections.add((Selection<?>)expression);
        return this;
    }

    public Select<T> select(Runnable runnable) {
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (InterceptorHandler)this.getter(path -> this.selections.add((Selection<?>)path)));
        runnable.run();
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (InterceptorHandler)this.where);
        return this;
    }

    public Select<T> select(Consumer<T> consumer) {
        Class entityClass = Interceptor.getTargetClass(this.where.getTemplate());
        Object t = this.applyGetter(entityClass, path -> this.selections.add((Selection<?>)path));
        consumer.accept(t);
        return this;
    }

    public <R> Select<T> crossJoinManyToOneWhere(Class<R> entityClass, Consumer<T> joinCondition, Consumer<R> consumer) {
        return this.crossJoinManyToOne(entityClass, joinCondition, (Select<R> nestedSelect) -> nestedSelect.where(consumer));
    }

    public <R> Select<T> crossJoinManyToOne(Class<R> entityClass, Consumer<T> joinCondition, BiConsumer<Select<R>, R> consumer) {
        return this.crossJoinManyToOne(entityClass, joinCondition, (Select<R> nestedSelect) -> nestedSelect.where(consumer));
    }

    public <R> Select<T> crossJoinManyToOne(Class<R> entityClass, Consumer<T> joinCondition, Consumer<Select<R>> consumer) {
        Root jointRoot = this.getQuery().from(entityClass);
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (arg_0, arg_1, arg_2) -> this.lambda$crossJoinManyToOne$4((From)jointRoot, arg_0, arg_1, arg_2));
        joinCondition.accept(this.getTemplate());
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (InterceptorHandler)this.where);
        Where where = new Where(this.where, (Path)jointRoot);
        Select<T> joinSelect = new Select<T>(this, where, jointRoot);
        consumer.accept(joinSelect);
        return this;
    }

    public <R> Select<T> crossJoinOneToManyWhere(Class<R> entityClass, Consumer<R> joinCondition, Consumer<R> consumer) {
        return this.crossJoinOneToMany(entityClass, joinCondition, (Select<R> nestedSelect) -> nestedSelect.where(consumer));
    }

    public <R> Select<T> crossJoinOneToMany(Class<R> entityClass, Consumer<R> joinCondition, BiConsumer<Select<R>, R> consumer) {
        return this.crossJoinOneToMany(entityClass, joinCondition, (Select<R> nestedSelect) -> nestedSelect.where(consumer));
    }

    public <R> Select<T> crossJoinOneToMany(Class<R> entityClass, Consumer<R> joinCondition, Consumer<Select<R>> consumer) {
        Root jointRoot = this.getQuery().from(entityClass);
        Object joinTemplate = Handler.interceptor.newInstance(entityClass, (arg_0, arg_1, arg_2) -> this.lambda$crossJoinOneToMany$7((From)jointRoot, arg_0, arg_1, arg_2));
        joinCondition.accept(joinTemplate);
        Where where = new Where(this.where, (Path)jointRoot);
        Select<T> joinSelect = new Select<T>(this, where, jointRoot);
        consumer.accept(joinSelect);
        return this;
    }

    public <R> Select<T> leftJoin(Runnable joinCondition, BiConsumer<Select<R>, R> consumer) {
        return this.join(JoinType.LEFT, joinCondition, consumer);
    }

    public <R> Select<T> leftJoin(Runnable joinCondition, Consumer<Select<R>> consumer) {
        return this.join(JoinType.LEFT, joinCondition, (sel, r) -> consumer.accept((Select)sel));
    }

    public Select<T> leftJoin(Runnable joinCondition) {
        return this.join(JoinType.LEFT, joinCondition, (sel, r) -> {});
    }

    public <R> Select<T> join(Runnable joinCondition, BiConsumer<Select<R>, R> consumer) {
        return this.join(JoinType.INNER, joinCondition, consumer);
    }

    public <R> Select<T> join(Runnable joinCondition, Consumer<Select<R>> consumer) {
        return this.join(JoinType.INNER, joinCondition, (sel, r) -> consumer.accept((Select)sel));
    }

    public Select<T> join(Runnable joinCondition) {
        return this.join(JoinType.INNER, joinCondition, (sel, r) -> {});
    }

    protected <R> Select<T> join(JoinType type, Runnable joinCondition, BiConsumer<Select<R>, R> consumer) {
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (target, thisMethod, args) -> {
            PropertyDescriptor desc = Reflection.propertyDescriptor((Method)thisMethod);
            String property = desc.getName();
            if (!thisMethod.equals(desc.getReadMethod())) {
                throw new UnsupportedOperationException("Only accepts getter");
            }
            Join join = this.getFrom().join(property, type);
            Where where = new Where(this.where, (Path)join);
            Select<T> joinSelect = new Select<T>(this, where, join);
            consumer.accept(joinSelect, where.getTemplate());
            return null;
        });
        joinCondition.run();
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (InterceptorHandler)this.where);
        return this;
    }

    public Select<T> fetch(Runnable joinCondition) {
        return this.fetch(JoinType.INNER, joinCondition);
    }

    public Select<T> leftFetch(Runnable joinCondition) {
        return this.fetch(JoinType.LEFT, joinCondition);
    }

    protected Select<T> fetch(JoinType type, Runnable joinCondition) {
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (target, thisMethod, args) -> {
            PropertyDescriptor desc = Reflection.propertyDescriptor((Method)thisMethod);
            String property = desc.getName();
            if (!thisMethod.equals(desc.getReadMethod())) {
                throw new UnsupportedOperationException("Only accepts getter");
            }
            this.getFrom().fetch(property, type);
            return null;
        });
        joinCondition.run();
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (InterceptorHandler)this.where);
        return this;
    }

    public Select<T> setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        if (this.parent != null) {
            this.parent.setMaxResults(maxResults);
        }
        return this;
    }

    public void count() {
        this.selections.add((Selection<?>)this.getBuilder().count(this.getFrom()));
    }

    public Select<T> asc(Runnable runnable) {
        OrderBy orderBy = new OrderBy(this.where.getEntityManager(), this.where.getBuilder(), this.where.getQuery(), (Path)this.getFrom());
        Interceptor.setInterceptorHandler(this.where.getTemplate(), orderBy);
        orderBy.desc = false;
        orderBy.orderByList = this.where.orderByList;
        runnable.run();
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (InterceptorHandler)this.where);
        return this;
    }

    public Select<T> desc(Runnable runnable) {
        OrderBy orderBy = new OrderBy(this.where.getEntityManager(), this.where.getBuilder(), this.where.getQuery(), (Path)this.getFrom());
        Interceptor.setInterceptorHandler(this.where.getTemplate(), orderBy);
        orderBy.desc = true;
        orderBy.orderByList = this.where.orderByList;
        runnable.run();
        Interceptor.setInterceptorHandler(this.where.getTemplate(), (InterceptorHandler)this.where);
        return this;
    }

    public <N extends Number> Expression<N> sum(String attribute) {
        return this.getBuilder().sum((Expression)this.where.getPath().get(attribute));
    }

    public <N> Expression coalesce(Expression<N> expression, N value) {
        CriteriaBuilder.Coalesce coalesce = this.getBuilder().coalesce();
        coalesce.value(expression);
        coalesce.value(value);
        return coalesce;
    }

    private /* synthetic */ Object lambda$crossJoinOneToMany$7(From jointRoot, Object target, Method thisMethod, Object[] args) throws Throwable {
        Predicate joinPredicate;
        PropertyDescriptor desc = Reflection.propertyDescriptor((Method)thisMethod);
        String property = desc.getName();
        if (thisMethod.equals(desc.getReadMethod())) {
            if (jointRoot.get(property).getJavaType().equals(this.getFrom().getJavaType())) {
                joinPredicate = this.getBuilder().equal(this.getFrom(), (Expression)jointRoot.get(property));
            } else {
                EntityType type = (EntityType)this.getFrom().getModel();
                String parentIdAttribute = type.getId(type.getIdType().getJavaType()).getName();
                if (!this.getFrom().get(parentIdAttribute).getJavaType().equals(jointRoot.get(property).getJavaType())) {
                    throw new IllegalArgumentException("Type mismatch: cannot join " + type.getName() + "." + parentIdAttribute + " to " + jointRoot.get(property));
                }
                joinPredicate = this.getBuilder().equal((Expression)this.getFrom().get(parentIdAttribute), (Expression)jointRoot.get(property));
            }
        } else {
            throw new UnsupportedOperationException("Only accepts getter");
        }
        this.where.getPredicates().add(joinPredicate);
        return null;
    }

    private /* synthetic */ Object lambda$crossJoinManyToOne$4(From jointRoot, Object target, Method thisMethod, Object[] args) throws Throwable {
        Predicate joinPredicate;
        PropertyDescriptor desc = Reflection.propertyDescriptor((Method)thisMethod);
        String property = desc.getName();
        if (thisMethod.equals(desc.getReadMethod())) {
            if (this.getFrom().get(property).getJavaType().equals(jointRoot.getJavaType())) {
                joinPredicate = this.getBuilder().equal((Expression)this.getFrom().get(property), (Expression)jointRoot);
            } else {
                EntityType type = (EntityType)jointRoot.getModel();
                String parentIdAttribute = type.getId(type.getIdType().getJavaType()).getName();
                if (!jointRoot.get(parentIdAttribute).getJavaType().equals(this.getFrom().get(property).getJavaType())) {
                    throw new IllegalArgumentException("Type mismatch: cannot join " + type.getName() + "." + parentIdAttribute + " to " + this.getFrom().get(property));
                }
                joinPredicate = this.getBuilder().equal((Expression)jointRoot.get(parentIdAttribute), (Expression)this.getFrom().get(property));
            }
        } else {
            throw new UnsupportedOperationException("Only accepts getter");
        }
        this.where.getPredicates().add(joinPredicate);
        return null;
    }
}

