/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist;

import com.google.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.metamodel.Metamodel;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.persist.EntityManagerConfig;
import net.e6tech.elements.persist.EntityManagerInvocationHandler;
import net.e6tech.elements.persist.EvictCollectionRegion;
import net.e6tech.elements.persist.EvictEntity;
import net.e6tech.elements.persist.EvictEntityRegion;

public abstract class EntityManagerProvider
implements ResourceProvider,
Initializable {
    private static final String MONITOR_TRANSACTION = EntityManagerProvider.class.getName() + ".transaction.monitor";
    private static final String LONG_TRANSACTION = EntityManagerProvider.class.getName() + ".transaction.longTransaction";
    private static final Logger logger = Logger.getLogger();
    @Inject(optional=true)
    private ExecutorService threadPool;
    @Inject(optional=true)
    private NotificationCenter center;
    protected EntityManagerFactory emf;
    private String persistenceUnitName;
    private Map persistenceProperties;
    private Broadcast broadcast;
    private long transactionTimeout = 0L;
    private boolean monitorTransaction = true;
    private long longTransaction = 200L;
    private boolean firstQuery = true;
    private AtomicInteger ignoreInitialLongTransactions = new AtomicInteger(1);
    private BlockingQueue<EntityManagerMonitor> monitorQueue = new LinkedBlockingQueue<EntityManagerMonitor>();
    private List<EntityManagerMonitor> entityManagerMonitors = new ArrayList<EntityManagerMonitor>();
    private long monitorIdle = 60000L;
    private boolean monitoring = false;

    public long getMonitorIdle() {
        return this.monitorIdle;
    }

    public void setMonitorIdle(long monitorIdle) {
        this.monitorIdle = monitorIdle;
    }

    public Broadcast getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(Broadcast broadcast) {
        this.broadcast = broadcast;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public Map getPersistenceProperties() {
        return this.persistenceProperties;
    }

    public void setPersistenceProperties(Map persistenceProperties) {
        this.persistenceProperties = persistenceProperties;
    }

    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public long getLongTransaction() {
        return this.longTransaction;
    }

    public void setLongTransaction(long longTransaction) {
        this.longTransaction = longTransaction;
    }

    public boolean isMonitorTransaction() {
        return this.monitorTransaction;
    }

    public void setMonitorTransaction(boolean monitorTransaction) {
        this.monitorTransaction = monitorTransaction;
    }

    public int getIgnoreInitialLongTransactions() {
        if (this.ignoreInitialLongTransactions == null) {
            return 0;
        }
        return this.ignoreInitialLongTransactions.get();
    }

    public void setIgnoreInitialLongTransactions(int n) {
        this.ignoreInitialLongTransactions = new AtomicInteger(n);
    }

    protected void evictCollectionRegion(EvictCollectionRegion notification) {
    }

    protected void evictEntityRegion(EvictEntityRegion region) {
    }

    protected void evictEntity(EvictEntity ref) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Resources resources) {
        this.emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, (Map)this.persistenceProperties);
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            Metamodel meta = this.emf.getMetamodel();
            meta.getManagedTypes().forEach(type -> {
                type.getDeclaredAttributes();
                type.getPersistenceType();
            });
        }
        NotificationCenter center = resources.getNotificationCenter();
        center.subscribe(EvictCollectionRegion.class, notice -> this.evictCollectionRegion((EvictCollectionRegion)((Object)notice.getUserObject())));
        center.subscribe(EvictEntityRegion.class, notice -> this.evictEntityRegion((EvictEntityRegion)((Object)notice.getUserObject())));
        center.subscribe(EvictEntity.class, notice -> this.evictEntity((EvictEntity)((Object)notice.getUserObject())));
    }

    public void onOpen(Resources resources) {
        Optional config = resources.configurator().annotation(EntityManagerConfig.class);
        if (config.isPresent() && ((EntityManagerConfig)config.get()).disable()) {
            throw new NotAvailableException();
        }
        long timeout = config.map(c -> c.timeout()).orElse(this.transactionTimeout);
        if (timeout == 0L) {
            timeout = this.transactionTimeout;
        }
        long timeoutExt = config.map(c -> c.timeoutExtension()).orElse(0L);
        timeout += timeoutExt;
        boolean monitor = config.map(c -> c.monitor()).orElse(this.monitorTransaction);
        long longQuery = config.map(c -> c.longTransaction()).orElse(this.longTransaction);
        if (longQuery == 0L) {
            longQuery = this.longTransaction;
        }
        if (this.firstQuery) {
            this.firstQuery = false;
            if (longQuery < 1000L) {
                longQuery = 1000L;
            }
        }
        EntityManager em = this.emf.createEntityManager();
        if (monitor) {
            this.monitor(new EntityManagerMonitor(em, System.currentTimeMillis() + timeout, new Throwable()));
        }
        EntityManagerInvocationHandler emHandler = new EntityManagerInvocationHandler(resources, em);
        emHandler.setLongTransaction(longQuery);
        emHandler.setIgnoreInitialLongTransactions(this.ignoreInitialLongTransactions);
        resources.bind(EntityManager.class, (Object)((EntityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)emHandler)));
        em.getTransaction().begin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor(EntityManagerMonitor monitor) {
        BlockingQueue<EntityManagerMonitor> blockingQueue = this.monitorQueue;
        synchronized (blockingQueue) {
            this.monitorQueue.offer(monitor);
            if (this.monitoring) {
                return;
            }
            this.monitoring = true;
        }
        if (this.threadPool == null) {
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            this.threadPool = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(group, runnable, "EntityManagerProvider");
                thread.setName("EntityManagerProvider-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            });
        }
        this.threadPool.execute(() -> {
            block30: {
                while (true) {
                    Collection<EntityManagerMonitor> collection;
                    BlockingQueue<EntityManagerMonitor> blockingQueue = this.monitorQueue;
                    synchronized (blockingQueue) {
                        this.monitoring = true;
                    }
                    long start = System.currentTimeMillis();
                    long expiration = 0L;
                    List<EntityManagerMonitor> list = this.entityManagerMonitors;
                    synchronized (list) {
                        this.monitorQueue.drainTo(this.entityManagerMonitors);
                        Iterator<EntityManagerMonitor> iterator = this.entityManagerMonitors.iterator();
                        while (iterator.hasNext()) {
                            EntityManagerMonitor m = iterator.next();
                            if (!m.entityManager.isOpen()) {
                                iterator.remove();
                                continue;
                            }
                            if (m.expiration < System.currentTimeMillis()) {
                                m.rollback();
                                iterator.remove();
                                continue;
                            }
                            if (expiration != 0L && m.expiration >= expiration) continue;
                            expiration = m.expiration;
                        }
                    }
                    long sleep = 0L;
                    if (expiration > 0L && (sleep = expiration - System.currentTimeMillis()) < 0L) {
                        sleep = this.entityManagerMonitors.size() > 0 ? 1L : 0L;
                    }
                    EntityManagerMonitor newMonitor = null;
                    try {
                        newMonitor = sleep == 0L ? this.monitorQueue.poll(this.monitorIdle, TimeUnit.MILLISECONDS) : this.monitorQueue.poll(sleep, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (newMonitor != null) {
                        collection = this.entityManagerMonitors;
                        synchronized (collection) {
                            this.entityManagerMonitors.add(newMonitor);
                            continue;
                        }
                    }
                    collection = this.monitorQueue;
                    synchronized (collection) {
                        if (this.monitorQueue.size() == 0 && this.entityManagerMonitors.size() == 0 && System.currentTimeMillis() - start > this.monitorIdle) {
                            this.monitoring = false;
                            break block30;
                        }
                    }
                }
                finally {
                    BlockingQueue<EntityManagerMonitor> blockingQueue = this.monitorQueue;
                    synchronized (blockingQueue) {
                        this.monitoring = false;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommit(Resources resources) {
        try {
            EntityManager em = (EntityManager)resources.getInstance(EntityManager.class);
            em.getTransaction().commit();
            em.clear();
            em.close();
            Optional config = resources.configurator().annotation(EntityManagerConfig.class);
            boolean monitor = config.map(c -> c.monitor()).orElse(this.monitorTransaction);
            if (monitor) {
                this.monitor(new EntityManagerMonitor(em, System.currentTimeMillis(), new Throwable()));
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        finally {
            this.cleanup(resources);
        }
    }

    public void afterCommit(Resources resources) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAbort(Resources resources) {
        try {
            EntityManager em = (EntityManager)resources.getInstance(EntityManager.class);
            em.getTransaction().rollback();
            em.clear();
            em.close();
            Optional config = resources.configurator().annotation(EntityManagerConfig.class);
            boolean monitor = config.map(c -> c.monitor()).orElse(this.monitorTransaction);
            if (monitor) {
                this.monitor(new EntityManagerMonitor(em, System.currentTimeMillis(), new Throwable()));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.cleanup(resources);
        }
    }

    protected void cleanup(Resources resources) {
    }

    public void onClosed(Resources resources) {
    }

    public void onShutdown() {
        if (this.emf.isOpen()) {
            this.emf.close();
        }
    }

    private static class EntityManagerMonitor {
        EntityManager entityManager;
        long expiration;
        Throwable throwable;

        EntityManagerMonitor(EntityManager entityManager, long expiration, Throwable throwable) {
            this.entityManager = entityManager;
            this.expiration = expiration;
            this.throwable = throwable;
        }

        boolean rollback() {
            if (this.entityManager.isOpen()) {
                this.entityManager.getTransaction().setRollbackOnly();
                this.entityManager.close();
                logger.warn("EntityManagerProvider timeout", this.throwable);
                return true;
            }
            return false;
        }
    }
}

