/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import net.e6tech.elements.common.logging.Logger;

public class Watcher
implements InvocationHandler {
    protected static Logger logger = Logger.getLogger();
    private static ThreadLocal<Stack<Long>> gracePeriod = new ThreadLocal();
    private Object target;
    private boolean monitorTransaction = true;
    private long longTransaction = 200L;
    private AtomicInteger ignoreInitialLongTransactions;

    public static void addGracePeriod(long time) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Stack<Long> stack = gracePeriod.get();
        if (stack == null) {
            return;
        }
        for (int i = 0; i < stack.size(); ++i) {
            long existing = (Long)stack.get(i);
            stack.set(i, existing + time);
        }
    }

    protected static long getGracePeriod() {
        if (!logger.isDebugEnabled()) {
            return 0L;
        }
        Stack<Long> stack = gracePeriod.get();
        if (stack == null) {
            return 0L;
        }
        return stack.peek();
    }

    protected static void clearGracePeriod() {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Stack<Long> stack = gracePeriod.get();
        if (stack != null) {
            stack.pop();
            if (stack.size() == 0) {
                gracePeriod.remove();
            }
        }
    }

    protected static void initGracePeriod() {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Stack<Long> stack = gracePeriod.get();
        if (stack == null) {
            stack = new Stack();
            gracePeriod.set(stack);
        }
        stack.push(0L);
    }

    public Watcher(Object target) {
        this.target = target;
    }

    public long getLongTransaction() {
        return this.longTransaction;
    }

    public void setLongTransaction(long longTransaction) {
        this.longTransaction = longTransaction;
    }

    public AtomicInteger getIgnoreInitialLongTransactions() {
        return this.ignoreInitialLongTransactions;
    }

    public void setIgnoreInitialLongTransactions(AtomicInteger ignoreInitialLongTransactions) {
        this.ignoreInitialLongTransactions = ignoreInitialLongTransactions;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public boolean isMonitorTransaction() {
        return this.monitorTransaction;
    }

    public void setMonitorTransaction(boolean monitorTransaction) {
        this.monitorTransaction = monitorTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Watcher.initGracePeriod();
            Object object = this.doInvoke(proxy, method, args);
            return object;
        }
        finally {
            Watcher.clearGracePeriod();
        }
    }

    public Object doInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            Object object = method.invoke(this.target, args);
            return object;
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            this.log(method, args, duration);
        }
    }

    protected void log(Method method, Object[] args, long duration) {
        int left;
        if (!logger.isDebugEnabled() || duration < this.longTransaction + Watcher.getGracePeriod()) {
            if (duration >= this.longTransaction) {
                System.currentTimeMillis();
            }
            return;
        }
        if (this.ignoreInitialLongTransactions != null && (left = this.ignoreInitialLongTransactions.decrementAndGet()) >= 0) {
            return;
        }
        Throwable th = new Throwable();
        StackTraceElement[] trace = th.getStackTrace();
        StringBuilder builder = new StringBuilder();
        builder.append("Long transaction: " + duration + "ms. Method called=" + method.getName() + "\n");
        for (int i = 3; i < 20 && i != trace.length; ++i) {
            builder.append("\tat " + trace[i] + "\n");
        }
        if (trace.length > 20) {
            builder.append("...\n");
        }
        logger.debug(builder.toString());
    }
}

