/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.serialization;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.DefaultObjectFinder;
import net.e6tech.elements.common.serialization.ObjectReference;

public class ObjectFinder
extends DefaultObjectFinder {
    private static Logger logger = Logger.getLogger();

    public Object replaceObject(Object obj) {
        return obj;
    }

    public boolean hasObjectReference(Resources resources, Class cls) {
        if (super.hasObjectReference(resources, cls)) {
            return true;
        }
        return this.hasEntityManagerObjectReference(resources, cls);
    }

    public ObjectReference toReference(Resources resources, Object object) {
        if (object == null) {
            return null;
        }
        if (this.hasEntityManagerObjectReference(resources, object.getClass())) {
            Object id;
            Class<?> cls;
            block9: {
                EntityManager em = (EntityManager)resources.getInstance(EntityManager.class);
                cls = object.getClass();
                id = null;
                Metamodel model = em.getMetamodel();
                try {
                    EntityType type = null;
                    try {
                        type = model.entity(cls);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (type == null) {
                        return null;
                    }
                    SingularAttribute attr = type.getId(type.getIdType().getJavaType());
                    Member member = attr.getJavaMember();
                    if (member instanceof Field) {
                        ((Field)member).setAccessible(true);
                        id = ((Field)member).get(object);
                        break block9;
                    }
                    if (member instanceof Method) {
                        ((Method)member).setAccessible(true);
                        id = ((Method)member).invoke(object, new Object[0]);
                        break block9;
                    }
                    return null;
                }
                catch (Throwable th) {
                    return null;
                }
            }
            ObjectReference ref = new ObjectReference();
            ref.setId(id);
            ref.setType(cls.getName());
            return ref;
        }
        return super.toReference(resources, object);
    }

    public Object toObject(Resources resources, ObjectReference ref) {
        try {
            EntityManager em = (EntityManager)resources.getInstance(EntityManager.class);
            Class<?> cls = em.getClass().getClassLoader().loadClass(ref.getType());
            if (this.hasEntityManagerObjectReference(resources, cls)) {
                if (ref.getId() == null) {
                    return null;
                }
                Object obj = em.find(cls, ref.getId());
                if (obj == null) {
                    return null;
                }
                resources.inject(obj);
                return obj;
            }
            return super.toObject(resources, ref);
        }
        catch (ClassNotFoundException e) {
            throw logger.runtimeException((Throwable)e);
        }
        catch (Throwable th) {
            throw logger.runtimeException("Cannot locate instance using ObjectReference " + ref, th);
        }
    }

    protected boolean hasEntityManagerObjectReference(Resources resources, Class cls) {
        try {
            EntityManager em = (EntityManager)resources.getInstance(EntityManager.class);
            Metamodel model = em.getMetamodel();
            try {
                return model.entity(cls) != null;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
    }
}

