/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.persist.Watcher;

public class EntityManagerInvocationHandler
extends Watcher {
    private Resources resources;
    private AtomicInteger ignoreInitialLongTransaction;

    public EntityManagerInvocationHandler(Resources resources, EntityManager em) {
        super(em);
        this.resources = resources;
    }

    protected EntityManagerInvocationHandler(Object target) {
        super(target);
    }

    @Override
    public Object doInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        long start = System.currentTimeMillis();
        Object ret = null;
        try {
            ret = method.invoke(this.getTarget(), args);
        }
        catch (InvocationTargetException ex) {
            try {
                throw ex.getCause();
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled() && this.isMonitorTransaction()) {
                    long duration = System.currentTimeMillis() - start;
                    Class<?> returnType = method.getReturnType();
                    if (ret != null && Query.class.isAssignableFrom(returnType)) {
                        EntityManagerInvocationHandler handler = new EntityManagerInvocationHandler(ret);
                        handler.setLongTransaction(this.getLongTransaction());
                        handler.setIgnoreInitialLongTransactions(this.getIgnoreInitialLongTransactions());
                        ret = returnType.isInterface() ? Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{returnType}, (InvocationHandler)handler) : Proxy.newProxyInstance(this.getClass().getClassLoader(), returnType.getInterfaces(), (InvocationHandler)handler);
                    }
                    this.log(method, args, duration);
                }
                throw throwable;
            }
        }
        if (logger.isDebugEnabled() && this.isMonitorTransaction()) {
            long duration = System.currentTimeMillis() - start;
            Class<?> returnType = method.getReturnType();
            if (ret != null && Query.class.isAssignableFrom(returnType)) {
                EntityManagerInvocationHandler handler = new EntityManagerInvocationHandler(ret);
                handler.setLongTransaction(this.getLongTransaction());
                handler.setIgnoreInitialLongTransactions(this.getIgnoreInitialLongTransactions());
                ret = returnType.isInterface() ? Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{returnType}, (InvocationHandler)handler) : Proxy.newProxyInstance(this.getClass().getClassLoader(), returnType.getInterfaces(), (InvocationHandler)handler);
            }
            this.log(method, args, duration);
        }
        return ret;
    }
}

