/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.criteria;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.persist.criteria.Comparison;
import net.e6tech.elements.persist.criteria.Handler;

public class Where<T>
extends Handler {
    Where parent;
    T template;
    Comparison comparison = Comparison.equal;
    List<Predicate> predicates = new ArrayList<Predicate>();
    List<Order> orderByList = new ArrayList<Order>();

    public Where(Where parent, Path path) {
        this(parent.getEntityManager(), parent.getBuilder(), parent.getQuery(), path);
        this.parent = parent;
        this.predicates = parent.predicates;
        this.comparison = parent.getComparison();
        this.orderByList = parent.getOrderByList();
    }

    public Where(EntityManager entityManager, CriteriaBuilder builder, CriteriaQuery query, Path path) {
        super(entityManager, builder, query, path);
        this.template = Handler.interceptor.newInstance(path.getJavaType(), (InterceptorHandler)this);
    }

    public T getTemplate() {
        return this.template;
    }

    public void setTemplate(T template) {
        this.template = template;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(List<Predicate> predicates) {
        this.predicates = predicates;
    }

    public List<Order> getOrderByList() {
        return this.orderByList;
    }

    public void setOrderByList(List<Order> orderByList) {
        this.orderByList = orderByList;
    }

    @Override
    public void onQuery() {
        if (this.getPredicates().size() > 0) {
            this.getQuery().where(this.getPredicates().toArray(new Predicate[this.getPredicates().size()]));
        }
        if (this.orderByList.size() > 0) {
            this.getQuery().orderBy(this.orderByList);
        }
    }

    public Object invoke(Object interceptorInstance, Method thisMethod, Object target, Method proceed, Object[] args) throws Throwable {
        PropertyDescriptor desc = Reflection.propertyDescriptor((Method)thisMethod);
        String property = desc.getName();
        CriteriaBuilder builder = this.getBuilder();
        CriteriaQuery query = this.getQuery();
        if (thisMethod.equals(desc.getReadMethod())) {
            Class<?> cls = thisMethod.getReturnType();
            if (!Modifier.isFinal(cls.getModifiers())) {
                Where<T> where = new Where<T>(this, this.getPath().get(property));
                return where.getTemplate();
            }
            return null;
        }
        Path current = this.getPath().get(property);
        this.predicates.add(this.comparison.compare(builder, (Expression)current, args[0]));
        return null;
    }
}

