/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.hibernate;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.ObjectReference;
import net.e6tech.elements.common.util.InitialContextFactory;
import net.e6tech.elements.persist.EntityManagerProvider;
import net.e6tech.elements.persist.EvictCollectionRegion;
import net.e6tech.elements.persist.EvictEntity;
import net.e6tech.elements.persist.EvictEntityRegion;
import net.e6tech.elements.persist.PersistenceInterceptor;
import org.hibernate.Cache;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.SessionImpl;

public class HibernateEntityManagerProvider
extends EntityManagerProvider {
    private static Logger logger = Logger.getLogger();
    private Map<String, IdentifierGenerator> identifierGenerators = new LinkedHashMap<String, IdentifierGenerator>();
    private Interceptor interceptor = new Interceptor();

    public void initialize(Resources resources) {
        if (System.getProperty("java.naming.factory.initial") == null) {
            InitialContextFactory.setDefault();
        }
        if (this.identifierGenerators.size() > 0) {
            LinkedHashMap<String, Class> strategies = new LinkedHashMap<String, Class>();
            for (Map.Entry<String, IdentifierGenerator> entry : this.identifierGenerators.entrySet()) {
                Class cls = this.interceptor.newPrototypeClass(entry.getValue().getClass(), (Object)entry.getValue());
                strategies.put(entry.getKey(), cls);
            }
            this.getPersistenceProperties().put("hibernate.ejb.identifier_generator_strategy_provider", () -> strategies);
        }
        super.initialize(resources);
    }

    public HibernateEntityManagerProvider register(String strategy, IdentifierGenerator generator) {
        this.identifierGenerators.put(strategy, generator);
        return this;
    }

    protected void evictCollectionRegion(EvictCollectionRegion notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        hibernateCache.evictCollectionData(notification.getRole());
    }

    protected void evictEntityRegion(EvictEntityRegion notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        hibernateCache.evictEntityData(notification.getEntityName());
    }

    protected void evictEntity(EvictEntity notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        try {
            ObjectReference ref = notification.getObjectReference();
            hibernateCache.evictEntityData(((Object)((Object)this)).getClass().getClassLoader().loadClass(ref.getType()), (Serializable)ref.getId());
        }
        catch (ClassNotFoundException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void onOpen(Resources resources) {
        super.onOpen(resources);
        EntityManager em = (EntityManager)resources.getInstance(EntityManager.class);
        SessionImpl session = (SessionImpl)em.getDelegate();
        SessionFactoryImplementor factory = session.getSessionFactory();
        resources.bind(SessionImpl.class, (Object)session);
        resources.bind(SessionFactoryImplementor.class, (Object)factory);
        resources.bind(SessionFactory.class, (Object)factory);
        if (session.getInterceptor() instanceof PersistenceInterceptor) {
            PersistenceInterceptor interceptor = (PersistenceInterceptor)session.getInterceptor();
            interceptor.setResources(resources);
        }
    }

    public void afterOpen(Resources resources) {
        try {
            SessionImpl session = (SessionImpl)resources.getInstance(SessionImpl.class);
            if (session.getInterceptor() instanceof PersistenceInterceptor) {
                PersistenceInterceptor interceptor = (PersistenceInterceptor)session.getInterceptor();
                resources.inject((Object)interceptor);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    public void cleanup(Resources resources) {
        super.cleanup(resources);
        try {
            SessionImpl session = (SessionImpl)resources.getInstance(SessionImpl.class);
            if (session.getInterceptor() instanceof PersistenceInterceptor) {
                PersistenceInterceptor interceptor = (PersistenceInterceptor)session.getInterceptor();
                interceptor.cleanup(resources);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }
}

