/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.hibernate;

import java.util.Map;
import java.util.Properties;
import net.e6tech.elements.common.util.SystemException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class TableIdGenerator
extends TableGenerator
implements Cloneable {
    private String defaultTableName = "sequence";
    private int defaultInitialValue = 1;
    private int defaultIncrementSize = 100;
    private String defaultOptimizer = StandardOptimizerDescriptor.POOLED_LO.getExternalName();

    public TableIdGenerator clone() {
        try {
            return (TableIdGenerator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    public void setDefaultTableName(String defaultTableName) {
        this.defaultTableName = defaultTableName;
    }

    public int getDefaultInitialValue() {
        return this.defaultInitialValue;
    }

    public void setDefaultInitialValue(int defaultInitialValue) {
        this.defaultInitialValue = defaultInitialValue;
    }

    public int getDefaultIncrementSize() {
        return this.defaultIncrementSize;
    }

    public void setDefaultIncrementSize(int defaultIncrementSize) {
        this.defaultIncrementSize = defaultIncrementSize;
    }

    public String getDefaultOptimizer() {
        return this.defaultOptimizer;
    }

    public void setDefaultOptimizer(String defaultOptimizer) {
        this.defaultOptimizer = defaultOptimizer;
    }

    protected QualifiedName determineGeneratorTableName(Properties params, JdbcEnvironment jdbcEnvironment) {
        String tableName = ConfigurationHelper.getString((String)"table_name", (Map)params, (String)this.defaultTableName);
        if (tableName.contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(tableName);
        }
        Identifier catalog = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"catalog", (Map)params));
        Identifier schema = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"schema", (Map)params));
        return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnvironment.getIdentifierHelper().toIdentifier(tableName));
    }

    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt((String)"initial_value", (Map)params, (int)this.defaultInitialValue);
    }

    protected String determineDefaultSegmentValue(Properties params) {
        return params.getProperty("target_table");
    }

    protected int determineIncrementSize(Properties params) {
        return ConfigurationHelper.getInt((String)"increment_size", (Map)params, (int)this.defaultIncrementSize);
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) {
        if (params.getProperty("optimizer") == null) {
            params.setProperty("optimizer", this.defaultOptimizer);
        }
        super.configure(type, params, serviceRegistry);
    }
}

