/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.hibernate;

import java.io.Serializable;
import javax.persistence.EntityManager;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.ObjectReference;
import net.e6tech.elements.persist.EntityManagerProvider;
import net.e6tech.elements.persist.EvictCollectionRegion;
import net.e6tech.elements.persist.EvictEntity;
import net.e6tech.elements.persist.EvictEntityRegion;
import net.e6tech.elements.persist.PersistenceInterceptor;
import org.hibernate.Cache;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionImpl;

public class HibernateEntityManagerProvider
extends EntityManagerProvider {
    protected void evictCollectionRegion(EvictCollectionRegion notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        hibernateCache.evictCollectionRegion(notification.getRole());
    }

    protected void evictEntityRegion(EvictEntityRegion notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        hibernateCache.evictEntityRegion(notification.getEntityName());
    }

    protected void evictEntity(EvictEntity notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        try {
            ObjectReference ref = notification.getObjectReference();
            hibernateCache.evictEntity(((Object)((Object)this)).getClass().getClassLoader().loadClass(ref.getType()), (Serializable)ref.getId());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void onOpen(Resources resources) {
        super.onOpen(resources);
        EntityManager em = (EntityManager)resources.getInstance(EntityManager.class);
        SessionImpl session = (SessionImpl)em.getDelegate();
        SessionFactoryImplementor factory = session.getSessionFactory();
        resources.bind(SessionImpl.class, (Object)session);
        resources.bind(SessionFactoryImplementor.class, (Object)factory);
        if (session.getInterceptor() instanceof PersistenceInterceptor) {
            PersistenceInterceptor interceptor = (PersistenceInterceptor)session.getInterceptor();
            resources.inject((Object)interceptor);
        }
    }
}

