/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.invocation;

import akka.actor.typed.ActorRef;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.actor.typed.Receptor;
import net.e6tech.elements.common.federation.Registry;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.concurrent.Async;
import net.e6tech.elements.network.cluster.AsyncImpl;
import net.e6tech.elements.network.cluster.Local;
import net.e6tech.elements.network.cluster.RouteListener;
import net.e6tech.elements.network.cluster.invocation.InvocationEvents;
import net.e6tech.elements.network.cluster.invocation.Registrar;
import scala.concurrent.ExecutionContextExecutor;

public class RegistryActor
implements Registry {
    private static String path = "registry";
    public static final String REGISTRY_DISPATCHER = "registry-dispatcher";
    private Guardian guardian;
    private Registrar registrar;
    private ExecutionContextExecutor dispatcher;
    private long timeout = 10000L;
    private List<RouteListener> listeners = Collections.synchronizedList(new ArrayList());

    public static String getPath() {
        return path;
    }

    public static void setPath(String path) {
        RegistryActor.path = path;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void addRouteListener(RouteListener listener) {
        this.listeners.add(listener);
    }

    public void removeRouteListener(RouteListener listener) {
        this.listeners.remove(listener);
    }

    void onAnnouncement(String path) {
        this.dispatcher.execute(() -> {
            ArrayList<RouteListener> list = new ArrayList<RouteListener>(this.listeners);
            for (RouteListener l : list) {
                l.onAnnouncement(path);
            }
        });
    }

    void onTerminated(String path, ActorRef actor) {
        this.dispatcher.execute(() -> {
            ArrayList<RouteListener> list = new ArrayList<RouteListener>(this.listeners);
            for (RouteListener l : list) {
                l.onTerminated(path, actor.path().toString());
            }
        });
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    public void start(Guardian guardian) {
        this.guardian = guardian;
        this.dispatcher = guardian.getContext().getExecutionContext();
        this.registrar = (Registrar)guardian.childActor(Registrar.class).withName(RegistryActor.getPath()).spawnNow((Receptor)new Registrar(this));
    }

    public void shutdown() {
        this.registrar.talk().stop();
    }

    public Collection routes(String path) {
        return (Collection)((InvocationEvents.Response)this.registrar.talk(this.timeout).askAndWait(InvocationEvents.Response.class, ref -> new InvocationEvents.Routes((ActorRef)ref, path))).getValue();
    }

    public Collection routes(String qualifier, Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        for (Method method : interfaceClass.getMethods()) {
            String methodName;
            Local local = method.getAnnotation(Local.class);
            if (local != null || "hashCode".equals(methodName = method.getName()) && method.getParameterCount() == 0 || "equals".equals(methodName) && method.getParameterCount() == 1 || "toString".equals(methodName) && method.getParameterCount() == 0) continue;
            String p = this.fullyQualify(qualifier, interfaceClass, method);
            return this.routes(p);
        }
        return Collections.emptyList();
    }

    protected <R, U> CompletionStage<U> register(String path, BiFunction<ActorRef, Object[], R> function) {
        return this.registrar.talk(this.timeout).ask(ref -> new InvocationEvents.Registration((ActorRef)ref, path, function));
    }

    public <T> List<String> register(String qualifier, Class<T> interfaceClass, T implementation) {
        return this.register(qualifier, interfaceClass, implementation, null);
    }

    public <T> List<String> register(String qualifier, Class<T> interfaceClass, T implementation, InvocationHandler customizedInvoker) {
        CompletionStage stage = this.internalRegister(qualifier, interfaceClass, implementation, customizedInvoker);
        try {
            List list = stage.toCompletableFuture().get();
            return list.stream().map(r -> r.toString()).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<String> discover(String qualifier, Class<T> interfaceClass) {
        return this.register(qualifier, interfaceClass, null, null);
    }

    public <T, U> CompletionStage<List<U>> internalRegister(String qualifier, Class<T> interfaceClass, T implementation, InvocationHandler customizedInvoker) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass " + interfaceClass.getName() + " needs to be an interface.");
        }
        if (!Modifier.isPublic(interfaceClass.getModifiers())) {
            throw new IllegalArgumentException("interfaceClass " + interfaceClass.getName() + " needs to be public.");
        }
        ArrayList list = new ArrayList();
        for (Method method : interfaceClass.getMethods()) {
            String methodName;
            Local local = method.getAnnotation(Local.class);
            if (local != null || "hashCode".equals(methodName = method.getName()) && method.getParameterCount() == 0 || "equals".equals(methodName) && method.getParameterCount() == 1 || "toString".equals(methodName) && method.getParameterCount() == 0) continue;
            if (implementation == null) {
                this.register(this.fullyQualify(qualifier, interfaceClass, method), null).toCompletableFuture();
                continue;
            }
            if (customizedInvoker == null) {
                customizedInvoker = (target, meth, args) -> meth.invoke(target, args);
            }
            InvocationHandler invoker = customizedInvoker;
            list.add(this.register(this.fullyQualify(qualifier, interfaceClass, method), (actor, args) -> {
                try {
                    return invoker.invoke(implementation, method, (Object[])args);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new SystemException(e);
                }
            }).toCompletableFuture());
        }
        return CompletableFuture.supplyAsync(() -> {
            ArrayList results = new ArrayList();
            for (CompletableFuture stage : list) {
                try {
                    results.add(stage.get(this.timeout, TimeUnit.MILLISECONDS));
                }
                catch (Exception e) {
                    throw new SystemException((Throwable)e);
                }
            }
            return results;
        });
    }

    String fullyQualify(String qualifier, Class interfaceClass, Method method) {
        return Registry.fullyQualify((String)qualifier, (Class)interfaceClass, (Method)method);
    }

    public Function<Object[], CompletionStage<InvocationEvents.Response>> route(String qualifier, Class interfaceClass, Method method, long timeout) {
        return this.route(this.fullyQualify(qualifier, interfaceClass, method), timeout);
    }

    public Function<Object[], CompletionStage<InvocationEvents.Response>> route(String path, long timeout) {
        return arguments -> this.registrar.talk(timeout).ask(ref -> new InvocationEvents.Request((ActorRef<InvocationEvents.Response>)ref, path, timeout, (Object[])arguments));
    }

    public <T> Async<T> async(String qualifier, Class<T> interfaceClass) {
        return new AsyncImpl<T>(this, qualifier, interfaceClass, this.timeout);
    }

    public <T> Async<T> async(String qualifier, Class<T> interfaceClass, long timeout, Registry.Routing routing) {
        return new AsyncImpl<T>(this, qualifier, interfaceClass, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitLoop(BooleanSupplier test, long timeout) throws TimeoutException {
        final Object monitor = new Object();
        RouteListener listener = new RouteListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAnnouncement(String path) {
                Object object = monitor;
                synchronized (object) {
                    monitor.notifyAll();
                }
            }
        };
        try {
            this.addRouteListener(listener);
            long start = System.currentTimeMillis();
            boolean first = true;
            Object object = monitor;
            synchronized (object) {
                while (!test.getAsBoolean()) {
                    if (!first && System.currentTimeMillis() - start > timeout) {
                        throw new TimeoutException();
                    }
                    if (first) {
                        first = false;
                    }
                    try {
                        long wait = timeout - (System.currentTimeMillis() - start);
                        if (wait <= 0L) continue;
                        monitor.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }
        finally {
            this.removeRouteListener(listener);
        }
    }

    public void waitForRoutes(String qualifier, Predicate<Collection> predicate, long timeout) throws TimeoutException {
        this.waitLoop(() -> predicate.test(this.routes(qualifier)), timeout);
    }

    public void waitForRoutes(String qualifier, Class interfaceClass, Predicate<Collection> predicate, long timeout) throws TimeoutException {
        this.waitLoop(() -> predicate.test(this.routes(qualifier, interfaceClass)), timeout);
    }
}

